/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers;

import ai.wanaku.core.mcp.common.resolvers.ToolsResolver;
import ai.wanaku.core.mcp.common.resolvers.util.NoopToolsResolver;
import ai.wanaku.routers.AbstractProvider;
import ai.wanaku.routers.config.WanakuRouterConfig;
import ai.wanaku.routers.proxies.ToolsProxy;
import ai.wanaku.routers.proxies.tools.InvokerProxy;
import ai.wanaku.routers.resolvers.WanakuToolsResolver;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.profile.IfBuildProfile;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.File;
import org.jboss.logging.Logger;
import picocli.CommandLine;

@ApplicationScoped
public class ToolsProvider
extends AbstractProvider<ToolsProxy, ToolsResolver> {
    private static final Logger LOG = Logger.getLogger(ToolsProvider.class);
    @Inject
    CommandLine.ParseResult parseResult;
    @Inject
    WanakuRouterConfig config;

    @Produces
    @IfBuildProfile(anyOf={"dev", "test"})
    public ToolsResolver devResolver() {
        if (this.parseResult.isUsageHelpRequested() || this.parseResult.isVersionHelpRequested()) {
            return new NoopToolsResolver();
        }
        File resourcesIndexFile = this.initializeResourcesIndex(this.config.indexesPath(), "tools.json");
        LOG.infof("Using resources index file: %s", (Object)resourcesIndexFile.getAbsolutePath());
        return new WanakuToolsResolver(resourcesIndexFile, new InvokerProxy());
    }

    @Override
    @Produces
    @DefaultBean
    ToolsResolver getResolver() {
        if (this.parseResult.isUsageHelpRequested() || this.parseResult.isVersionHelpRequested()) {
            return new NoopToolsResolver();
        }
        File resourcesIndexFile = this.initializeIndex();
        return new WanakuToolsResolver(resourcesIndexFile, new InvokerProxy());
    }

    @Override
    protected File initializeIndex() {
        String defaultValue = this.config.indexesPath();
        String value = (String)this.parseResult.matchedOptionValue("indexes-path", (Object)defaultValue);
        String indexPath = value.replace("${user.home}", System.getProperty("user.home"));
        return this.initializeResourcesIndex(indexPath, "tools.json");
    }
}

