/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers.proxies.resources;

import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.api.types.management.Service;
import ai.wanaku.core.exchange.InquireReply;
import ai.wanaku.core.exchange.InquireRequest;
import ai.wanaku.core.exchange.InquirerGrpc;
import ai.wanaku.core.exchange.ResourceAcquirerGrpc;
import ai.wanaku.core.exchange.ResourceReply;
import ai.wanaku.core.exchange.ResourceRequest;
import ai.wanaku.core.mcp.providers.ResourceRegistry;
import ai.wanaku.routers.proxies.ResourceProxy;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.TextResourceContents;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class ResourceAcquirerProxy
implements ResourceProxy {
    private static final Logger LOG = Logger.getLogger(ResourceAcquirerProxy.class);

    @Override
    public List<ResourceContents> eval(ResourceManager.ResourceArguments arguments, ResourceReference mcpResource) {
        Service service = ResourceRegistry.getInstance().getEntryForService(mcpResource.getType());
        if (service == null) {
            String message = String.format("There is no service registered for service %s", mcpResource.getType());
            LOG.error((Object)message);
            TextResourceContents textResourceContents = new TextResourceContents(arguments.requestUri().value(), message, "text/plain");
            return List.of(textResourceContents);
        }
        LOG.infof("Requesting %s from %s", (Object)mcpResource.getName(), (Object)service.getTarget());
        ResourceReply reply = this.acquireRemotely(mcpResource, service.getTarget());
        if (reply.getIsError()) {
            TextResourceContents textResourceContents = new TextResourceContents(arguments.requestUri().value(), reply.getContent(), "text/plain");
            return List.of(textResourceContents);
        }
        TextResourceContents textResourceContents = new TextResourceContents(arguments.requestUri().value(), reply.getContent(), mcpResource.getMimeType());
        return List.of(textResourceContents);
    }

    @Override
    public String name() {
        return "";
    }

    private ResourceReply acquireRemotely(ResourceReference mcpResource, String target) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        ResourceRequest request = ResourceRequest.newBuilder().setLocation(mcpResource.getLocation()).setType(mcpResource.getType()).setName(mcpResource.getName()).build();
        ResourceAcquirerGrpc.ResourceAcquirerBlockingStub blockingStub = ResourceAcquirerGrpc.newBlockingStub((Channel)channel);
        return blockingStub.resourceAcquire(request);
    }

    @Override
    public Map<String, String> getServiceConfigurations(String target) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        InquireRequest inquireRequest = InquireRequest.newBuilder().build();
        InquirerGrpc.InquirerBlockingStub blockingStub = InquirerGrpc.newBlockingStub((Channel)channel);
        InquireReply inquire = blockingStub.inquire(inquireRequest);
        return inquire.getServiceConfigurationsMap();
    }
}

