/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers.proxies.tools;

import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.management.Configurations;
import ai.wanaku.api.types.management.Service;
import ai.wanaku.core.exchange.InquireReply;
import ai.wanaku.core.exchange.InquireRequest;
import ai.wanaku.core.exchange.InquirerGrpc;
import ai.wanaku.core.exchange.ToolInvokeReply;
import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.exchange.ToolInvokerGrpc;
import ai.wanaku.core.mcp.providers.ServiceRegistry;
import ai.wanaku.routers.proxies.ToolsProxy;
import ai.wanaku.routers.proxies.tools.Request;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import java.util.Map;
import org.jboss.logging.Logger;

public class InvokerProxy
implements ToolsProxy {
    private static final Logger LOG = Logger.getLogger(InvokerProxy.class);

    public ToolResponse call(ToolReference toolReference, ToolManager.ToolArguments toolArguments) {
        Service service = ServiceRegistry.getInstance().getEntryForService(toolReference.getType());
        if (service == null) {
            return ToolResponse.error((String)("There is no host registered for service " + toolReference.getType()));
        }
        LOG.infof("Invoking %s on %s", (Object)toolReference.getType(), (Object)service);
        try {
            ToolInvokeReply invokeReply = InvokerProxy.invokeRemotely(toolReference, toolArguments, service);
            if (invokeReply.getIsError()) {
                return ToolResponse.error((String)invokeReply.getContent());
            }
            return ToolResponse.success((String)invokeReply.getContent());
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Unable to call endpoint: %s", (Object)e.getMessage());
            return ToolResponse.error((String)e.getMessage());
        }
    }

    private static ToolInvokeReply invokeRemotely(ToolReference toolReference, ToolManager.ToolArguments toolArguments, Service service) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)service.getTarget()).usePlaintext().build();
        Map configurations = service.getConfigurations().getConfigurations();
        Map collect = Configurations.toStringMap((Map)configurations);
        Request result = Request.newRequest(toolReference, toolArguments);
        ToolInvokeRequest toolInvokeRequest = ToolInvokeRequest.newBuilder().setBody(result.body()).setUri(result.uri()).putAllServiceConfigurations(collect).build();
        ToolInvokerGrpc.ToolInvokerBlockingStub blockingStub = ToolInvokerGrpc.newBlockingStub((Channel)channel);
        return blockingStub.invokeTool(toolInvokeRequest);
    }

    @Override
    public Map<String, String> getServiceConfigurations(String target) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        InquireRequest inquireRequest = InquireRequest.newBuilder().build();
        InquirerGrpc.InquirerBlockingStub blockingStub = InquirerGrpc.newBlockingStub((Channel)channel);
        InquireReply inquire = blockingStub.inquire(inquireRequest);
        return inquire.getServiceConfigurationsMap();
    }

    @Override
    public String name() {
        return "invoker";
    }
}

