/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers;

import ai.wanaku.core.mcp.common.resolvers.ToolsResolver;
import ai.wanaku.core.mcp.common.resolvers.util.NoopToolsResolver;
import ai.wanaku.core.mcp.providers.ServiceRegistry;
import ai.wanaku.core.util.VersionHelper;
import ai.wanaku.routers.AbstractProvider;
import ai.wanaku.routers.proxies.tools.InvokerProxy;
import ai.wanaku.routers.resolvers.WanakuToolsResolver;
import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.jboss.logging.Logger;
import picocli.CommandLine;

@ApplicationScoped
public class ToolsProvider
extends AbstractProvider<ToolsResolver> {
    private static final Logger LOG = Logger.getLogger(ToolsProvider.class);
    @Inject
    CommandLine.ParseResult parseResult;
    @Inject
    Instance<ServiceRegistry> serviceRegistryInstance;
    ServiceRegistry serviceRegistry;

    @PostConstruct
    void init() {
        this.serviceRegistry = (ServiceRegistry)this.serviceRegistryInstance.get();
    }

    @Override
    @Produces
    @DefaultBean
    ToolsResolver getResolver() {
        if (this.parseResult.isUsageHelpRequested() || this.parseResult.isVersionHelpRequested()) {
            return new NoopToolsResolver();
        }
        LOG.infof("Wanaku version %s is starting", (Object)VersionHelper.VERSION);
        return new WanakuToolsResolver(new InvokerProxy(this.serviceRegistry));
    }
}

