/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers.proxies.tools;

import ai.wanaku.api.types.CallableReference;
import ai.wanaku.api.types.Property;
import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.management.Configurations;
import ai.wanaku.api.types.management.Service;
import ai.wanaku.core.exchange.InquireReply;
import ai.wanaku.core.exchange.InquireRequest;
import ai.wanaku.core.exchange.InquirerGrpc;
import ai.wanaku.core.exchange.ToolInvokeReply;
import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.exchange.ToolInvokerGrpc;
import ai.wanaku.core.mcp.providers.ServiceRegistry;
import ai.wanaku.core.util.CollectionsHelper;
import ai.wanaku.routers.proxies.ToolsProxy;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.mcp.server.TextContent;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class InvokerProxy
implements ToolsProxy {
    private static final Logger LOG = Logger.getLogger(InvokerProxy.class);
    private static final String EMPTY_BODY = "";
    private final ServiceRegistry serviceRegistry;

    public InvokerProxy(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ToolResponse call(ToolManager.ToolArguments toolArguments, CallableReference toolReference) {
        if (toolReference instanceof ToolReference) {
            ToolReference ref = (ToolReference)toolReference;
            return this.call(toolArguments, ref);
        }
        LOG.errorf("Tool reference %s not supported", (Object)(toolReference == null ? "null" : toolReference.getClass().getName()));
        throw new UnsupportedOperationException("Only local tool call references should be invoked by this proxy");
    }

    public ToolResponse call(ToolManager.ToolArguments toolArguments, ToolReference toolReference) {
        Service service = this.serviceRegistry.getService(toolReference.getType());
        if (service == null) {
            return ToolResponse.error((String)("There is no host registered for service " + toolReference.getType()));
        }
        LOG.infof("Invoking %s on %s", (Object)toolReference.getType(), (Object)service);
        try {
            ToolInvokeReply invokeReply = InvokerProxy.invokeRemotely(toolReference, toolArguments, service);
            if (invokeReply.getIsError()) {
                return ToolResponse.error((String)((String)invokeReply.getContentList().get(0)));
            }
            ProtocolStringList contentList = invokeReply.getContentList();
            ArrayList contents = new ArrayList(invokeReply.getContentList().size());
            contentList.stream().map(TextContent::new).forEach(contents::add);
            return ToolResponse.success(contents);
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Unable to call endpoint: %s", (Object)e.getMessage());
            return ToolResponse.error((String)e.getMessage());
        }
    }

    private static ToolInvokeReply invokeRemotely(ToolReference toolReference, ToolManager.ToolArguments toolArguments, Service service) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)service.getTarget()).usePlaintext().build();
        Map configurations = service.getConfigurations().getConfigurations();
        Map serviceConfigurations = Configurations.toStringMap((Map)configurations);
        Map argumentsMap = CollectionsHelper.toStringStringMap((Map)toolArguments.args());
        Map inputSchema = toolReference.getInputSchema().getProperties();
        Map<String, String> serviceEndpointConfiguration = inputSchema.entrySet().stream().filter(entry -> {
            Property property = (Property)entry.getValue();
            return property != null && property.getTarget() != null && property.getScope() != null && property.getTarget().equals("configuration") && property.getScope().equals("service-endpoint");
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Property)entry.getValue()).getValue()));
        serviceConfigurations.putAll(serviceEndpointConfiguration);
        Map<String, String> headers = inputSchema.entrySet().stream().filter(entry -> {
            Property property = (Property)entry.getValue();
            return property != null && property.getTarget() != null && property.getScope() != null && property.getTarget().equals("header") && property.getScope().equals("service");
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Property)entry.getValue()).getValue()));
        String body = InvokerProxy.extractBody(toolReference, toolArguments);
        ToolInvokeRequest toolInvokeRequest = ToolInvokeRequest.newBuilder().setBody(body).setUri(toolReference.getUri()).putAllServiceConfigurations(serviceConfigurations).putAllHeaders(headers).putAllArguments(argumentsMap).build();
        ToolInvokerGrpc.ToolInvokerBlockingStub blockingStub = ToolInvokerGrpc.newBlockingStub((Channel)channel);
        return blockingStub.invokeTool(toolInvokeRequest);
    }

    private static String extractBody(ToolReference toolReference, ToolManager.ToolArguments toolArguments) {
        Map properties = toolReference.getInputSchema().getProperties();
        Property bodyProp = (Property)properties.get("wanaku_body");
        if (bodyProp == null) {
            return EMPTY_BODY;
        }
        String body = (String)toolArguments.args().get("wanaku_body");
        if (body == null) {
            return EMPTY_BODY;
        }
        return body;
    }

    @Override
    public Map<String, String> getServiceConfigurations(String target) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        InquireRequest inquireRequest = InquireRequest.newBuilder().build();
        InquirerGrpc.InquirerBlockingStub blockingStub = InquirerGrpc.newBlockingStub((Channel)channel);
        InquireReply inquire = blockingStub.inquire(inquireRequest);
        return inquire.getServiceConfigurationsMap();
    }

    @Override
    public String name() {
        return "invoker";
    }
}

