/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers.resolvers;

import ai.wanaku.api.exceptions.ServiceUnavailableException;
import ai.wanaku.api.exceptions.ToolNotFoundException;
import ai.wanaku.api.exceptions.WanakuException;
import ai.wanaku.api.types.CallableReference;
import ai.wanaku.api.types.ForwardReference;
import ai.wanaku.api.types.InputSchema;
import ai.wanaku.api.types.Property;
import ai.wanaku.api.types.RemoteToolReference;
import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.core.mcp.client.ClientUtil;
import ai.wanaku.core.mcp.common.Tool;
import ai.wanaku.core.mcp.common.resolvers.ForwardResolver;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.mcp.client.ResourceContents;
import dev.langchain4j.mcp.client.ResourceRef;
import dev.langchain4j.mcp.client.ResourceResponse;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.TextResourceContents;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class WanakuForwardResolver
implements ForwardResolver {
    private ForwardReference reference;
    private ReentrantLock lock = new ReentrantLock();

    public WanakuForwardResolver(ForwardReference reference) {
        this.reference = reference;
    }

    public List<ResourceReference> listResources() throws ServiceUnavailableException {
        List<ResourceReference> list;
        block8: {
            McpClient client = ClientUtil.createClient((String)this.reference.getAddress());
            try {
                List resourceRefs = client.listResources();
                list = resourceRefs.stream().map(WanakuForwardResolver::remoteToLocal).collect(Collectors.toList());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ServiceUnavailableException.forName((String)this.reference.getAddress());
                }
            }
            client.close();
        }
        return list;
    }

    private static ResourceReference remoteToLocal(ResourceRef remoteRef) {
        ResourceReference ref = new ResourceReference();
        ref.setType("mcp-remote-resource");
        ref.setLocation(remoteRef.uri());
        ref.setName(remoteRef.name());
        ref.setDescription(remoteRef.description());
        ref.setMimeType(remoteRef.mimeType());
        return ref;
    }

    public List<RemoteToolReference> listTools() throws ServiceUnavailableException {
        ArrayList<RemoteToolReference> arrayList;
        block9: {
            McpClient client = ClientUtil.createClient((String)this.reference.getAddress());
            try {
                ArrayList<RemoteToolReference> references = new ArrayList<RemoteToolReference>();
                List toolSpecifications = client.listTools();
                for (ToolSpecification toolSpecification : toolSpecifications) {
                    RemoteToolReference toolReference = WanakuForwardResolver.createRemoteToolReference(toolSpecification);
                    references.add(toolReference);
                }
                arrayList = references;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ServiceUnavailableException.forName((String)this.reference.getAddress());
                }
            }
            client.close();
        }
        return arrayList;
    }

    private static RemoteToolReference createRemoteToolReference(ToolSpecification toolSpecification) {
        RemoteToolReference toolReference = new RemoteToolReference();
        toolReference.setName(toolSpecification.name());
        toolReference.setDescription(toolSpecification.description());
        toolReference.setType("mcp-remote-tool");
        InputSchema inputSchema = new InputSchema();
        JsonObjectSchema parameters = toolSpecification.parameters();
        Map properties = parameters.properties();
        for (Map.Entry<String, JsonSchemaElement> entry : properties.entrySet()) {
            WanakuForwardResolver.createProperties(entry, properties, inputSchema);
        }
        toolReference.setInputSchema(inputSchema);
        return toolReference;
    }

    private static void createProperties(Map.Entry<String, JsonSchemaElement> entry, Map<String, JsonSchemaElement> properties, InputSchema inputSchema) {
        String key = entry.getKey();
        JsonSchemaElement jsonSchemaElement = properties.get(key);
        if (jsonSchemaElement instanceof JsonStringSchema) {
            JsonStringSchema stringSchema = (JsonStringSchema)jsonSchemaElement;
            WanakuForwardResolver.createStringProperty(stringSchema, inputSchema, key);
        }
    }

    private static void createStringProperty(JsonStringSchema stringSchema, InputSchema inputSchema, String key) {
        String description = stringSchema.description();
        Property property = new Property();
        property.setDescription(description);
        property.setType("string");
        inputSchema.getProperties().put(key, property);
    }

    public List<io.quarkiverse.mcp.server.ResourceContents> read(ResourceManager.ResourceArguments arguments, ResourceReference mcpResource) {
        List<TextResourceContents> list;
        block8: {
            McpClient client = ClientUtil.createClient((String)this.reference.getAddress());
            try {
                ResourceResponse resourceResponse = client.readResource(mcpResource.getLocation());
                List contents = resourceResponse.contents();
                TextResourceContents textResourceContents = TextResourceContents.create((String)mcpResource.getLocation(), (String)((ResourceContents)contents.get(0)).asText().text());
                list = List.of(textResourceContents);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WanakuException((Throwable)e);
                }
            }
            client.close();
        }
        return list;
    }

    private String serializeArguments(Map<String, Object> arguments) {
        JsonObject content = new JsonObject();
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            content.put(entry.getKey(), entry.getValue());
        }
        return content.toString();
    }

    public synchronized Tool resolve(CallableReference toolReference) throws ToolNotFoundException {
        return new ForwardTool();
    }

    private class ForwardTool
    implements Tool {
        private ForwardTool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ToolResponse call(ToolManager.ToolArguments toolArguments, CallableReference toolReference) {
            try {
                ToolResponse toolResponse;
                block11: {
                    WanakuForwardResolver.this.lock.lock();
                    ToolExecutionRequest request = ToolExecutionRequest.builder().name(toolReference.getName()).arguments(WanakuForwardResolver.this.serializeArguments(toolArguments.args())).build();
                    McpClient client = ClientUtil.createClient((String)WanakuForwardResolver.this.reference.getAddress());
                    try {
                        String status = client.executeTool(request);
                        toolResponse = ToolResponse.success((String)status);
                        if (client == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            ToolResponse toolResponse2 = ToolResponse.error((String)e.getMessage());
                            return toolResponse2;
                        }
                    }
                    client.close();
                }
                return toolResponse;
            }
            finally {
                WanakuForwardResolver.this.lock.unlock();
            }
        }
    }
}

