/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routing.service;

import ai.wanaku.core.exchange.ParsedToolInvokeRequest;
import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.services.routing.Client;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.tavily.TavilyWebSearchEngine;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@ApplicationScoped
public class TavilyClient
implements Client {
    private static final Logger LOG = Logger.getLogger(TavilyClient.class);
    private final ProducerTemplate producer;
    WebSearchEngine tavilyWebSearchEngine;

    public TavilyClient(CamelContext camelContext) {
        this.producer = camelContext.createProducerTemplate();
        String tavilyApiKey = ConfigProvider.getConfig().getConfigValue("tavily.api.key").getValue();
        this.tavilyWebSearchEngine = TavilyWebSearchEngine.builder().apiKey(tavilyApiKey).includeRawContent(Boolean.valueOf(true)).build();
        camelContext.getRegistry().bind("tavily", (Object)this.tavilyWebSearchEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exchange(ToolInvokeRequest request) {
        try {
            this.producer.start();
            Object baseUri = "langchain4j-web-search:test?webSearchEngine=#tavily";
            if (request.getArgumentsMap().containsKey("maxResults")) {
                baseUri = (String)baseUri + "&maxResults={maxResults}";
            }
            ParsedToolInvokeRequest parsedRequest = ParsedToolInvokeRequest.parseRequest((String)baseUri, (ToolInvokeRequest)request);
            Object object = this.producer.requestBody(parsedRequest.uri(), (Object)parsedRequest.body());
            return object;
        }
        finally {
            this.producer.stop();
        }
    }
}

