/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.tool.exec;

import ai.wanaku.core.exchange.InquireReply;
import ai.wanaku.core.exchange.InquireRequest;
import ai.wanaku.core.exchange.Inquirer;
import ai.wanaku.core.exchange.InvocationDelegate;
import ai.wanaku.core.exchange.ToolInvokeReply;
import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.exchange.ToolInvoker;
import ai.wanaku.core.service.discovery.util.DiscoveryUtil;
import ai.wanaku.core.services.config.WanakuToolConfig;
import io.quarkus.grpc.GrpcService;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.scheduler.Scheduled;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@GrpcService
public class InvocationService
implements ToolInvoker,
Inquirer {
    private static final Logger LOG = Logger.getLogger(InvocationService.class);
    @Inject
    InvocationDelegate delegate;
    @Inject
    WanakuToolConfig config;
    @ConfigProperty(name="quarkus.grpc.server.port")
    int port;

    @Blocking
    public Uni<ToolInvokeReply> invokeTool(ToolInvokeRequest request) {
        return Uni.createFrom().item(() -> this.delegate.invoke(request));
    }

    public Uni<InquireReply> inquire(InquireRequest request) {
        InquireReply reply = InquireReply.newBuilder().putAllServiceConfigurations(this.delegate.serviceConfigurations()).putAllCredentialsConfigurations(this.delegate.credentialsConfigurations()).build();
        return Uni.createFrom().item(() -> reply);
    }

    @Scheduled(every="{wanaku.service.tool.registration.interval}", delayed="{wanaku.service.tool.registration.delay-seconds}", delayUnit=TimeUnit.SECONDS)
    void register() {
        this.delegate.register();
    }

    void deregister(@Observes ShutdownEvent ev) {
        LOG.info((Object)"De-registering tool service");
        this.delegate.deregister(this.config.name(), DiscoveryUtil.resolveRegistrationAddress(), this.port);
    }
}

