/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.tool.telegram;

import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.services.tool.Client;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.apache.camel.ProducerTemplate;

@ApplicationScoped
public class TelegramClient
implements Client {
    @Inject
    ProducerTemplate producer;

    public Object exchange(ToolInvokeRequest request) {
        Map serviceConfigurationsMap = request.getServiceConfigurationsMap();
        String authToken = (String)serviceConfigurationsMap.get("authorizationToken");
        String chatId = (String)serviceConfigurationsMap.get("telegramId");
        if (chatId == null) {
            chatId = (String)request.getArgumentsMap().get("telegramId");
        }
        String baseUri = String.format("telegram:bots?authorizationToken=%s&chatId=%s", authToken, chatId);
        String message = (String)request.getArgumentsMap().get("message");
        this.producer.sendBody(baseUri, (Object)message);
        return String.format("Message sent successfully to telegramId %s", chatId);
    }
}

