/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.tool.yaml.route;

import ai.wanaku.api.exceptions.WanakuException;
import ai.wanaku.core.exchange.ParsedToolInvokeRequest;
import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.services.config.WanakuToolConfig;
import ai.wanaku.core.services.tool.Client;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.jboss.logging.Logger;

@ApplicationScoped
public class RouteClient
implements Client {
    private static final Logger LOG = Logger.getLogger(RouteClient.class);
    private final CamelContext camelContext;
    private final ProducerTemplate producer;
    private final WanakuToolConfig config;

    public RouteClient(CamelContext camelContext, WanakuToolConfig config) {
        this.camelContext = camelContext;
        this.producer = camelContext.createProducerTemplate();
        this.config = config;
    }

    public Object exchange(ToolInvokeRequest request) throws WanakuException {
        this.producer.start();
        LOG.infof("Loading resource from URI: %s", (Object)request.getUri());
        Resource resource = PluginHelper.getResourceLoader((CamelContext)this.camelContext).resolveResource(request.getUri());
        try {
            PluginHelper.getRoutesLoader((CamelContext)this.camelContext).loadRoutes(new Resource[]{resource});
        }
        catch (Exception e) {
            throw new WanakuException((Throwable)e);
        }
        ParsedToolInvokeRequest parsedRequest = ParsedToolInvokeRequest.parseRequest((ToolInvokeRequest)request);
        LOG.infof("Invoking tool at URI: %s", (Object)parsedRequest.uri());
        return this.producer.requestBody(this.config.baseUri(), (Object)parsedRequest.body(), String.class);
    }
}

