/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.config;

import ai.yue.library.base.crypto.config.properties.CryptoProperties;
import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.lang.Singleton;
import cn.hutool.crypto.SecureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CryptoProperties.class})
public class BaseCryptoAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(BaseCryptoAutoConfig.class);

    @Autowired
    private void init(CryptoProperties cryptoProperties) {
        String aes_keyt = cryptoProperties.getAes_keyt();
        if (StringUtils.isNotEmpty((CharSequence)aes_keyt)) {
            Singleton.put((Object)SecureUtil.aes((byte[])aes_keyt.getBytes()));
            log.info("\u3010\u521d\u59cb\u5316\u5de5\u5177-SecureSingleton\u3011AES\u5355\u4f8b\u914d\u7f6e ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        }
        String rsa_public_keyt = cryptoProperties.getRsa_public_keyt();
        String rsa_private_keyt = cryptoProperties.getRsa_private_keyt();
        if (StringUtils.isNotEmpty((CharSequence)rsa_public_keyt) || StringUtils.isNotEmpty((CharSequence)rsa_private_keyt)) {
            Singleton.put((Object)SecureUtil.rsa((String)rsa_private_keyt, (String)rsa_public_keyt));
            log.info("\u3010\u521d\u59cb\u5316\u5de5\u5177-SecureSingleton\u3011RSA\u5355\u4f8b\u914d\u7f6e ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
        }
    }
}

