/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.annotation.key.exchange;

import ai.yue.library.base.crypto.annotation.key.exchange.RequestDecrypt;
import ai.yue.library.base.crypto.constant.key.exchange.ExchangeKeyEnum;
import ai.yue.library.base.crypto.dao.key.exchange.KeyExchangeStorage;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.web.util.servlet.ServletUtils;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
@ConditionalOnClass(value={HttpServletRequest.class})
public class RequestDecryptHandler
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestDecryptHandler.class);

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return methodParameter.hasMethodAnnotation(RequestDecrypt.class);
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        RequestDecrypt methodAnnotation = (RequestDecrypt)parameter.getMethodAnnotation(RequestDecrypt.class);
        boolean enableExchangeKeyDecrypt = methodAnnotation.enableExchangeKeyDecrypt();
        SymmetricCrypto symmetricCrypto = null;
        if (enableExchangeKeyDecrypt) {
            String keyExchangeStorageKey = null;
            if (methodAnnotation.useAuthTokenGetExchangeKey()) {
                keyExchangeStorageKey = ServletUtils.getAuthToken();
            } else {
                String headerNameGetExchangeKey = methodAnnotation.headerNameGetExchangeKey();
                String paramNameGetExchangeKey = methodAnnotation.paramNameGetExchangeKey();
                keyExchangeStorageKey = ServletUtils.getRequest().getHeader(headerNameGetExchangeKey);
                if (StrUtil.isBlank((CharSequence)keyExchangeStorageKey)) {
                    keyExchangeStorageKey = ServletUtils.getRequest().getParameter(paramNameGetExchangeKey);
                }
            }
            if (StrUtil.isBlank((CharSequence)keyExchangeStorageKey)) {
                throw new ParamException("\u672a\u80fd\u83b7\u53d6\u5230\u4ea4\u6362\u5bc6\u94a5\uff1a1. \u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u8fdb\u884c\u8fc7\u5bc6\u94a5\u4ea4\u6362\uff0c2. \u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165keyExchangeStorageKey\uff08\u5982\uff1atoken\u522b\u540d\u3001UUID\u7b49\uff09\u5e76\u6307\u5b9a\u4e86\u5bf9\u5e94\u7684Get\u65b9\u5f0f\u3002");
            }
            KeyExchangeStorage keyExchangeStorage = (KeyExchangeStorage)SpringUtils.getBean(KeyExchangeStorage.class);
            String exchangeKey = keyExchangeStorage.getExchangeKey(keyExchangeStorageKey);
            log.debug("\u3010\u5bc6\u94a5\u4ea4\u6362-\u89e3\u5bc6\u3011keyExchangeStorageKey={}\uff0cexchangeKey={}", (Object)keyExchangeStorageKey, (Object)exchangeKey);
            ExchangeKeyEnum exchangeKeyType = methodAnnotation.exchangeKeyType();
            symmetricCrypto = exchangeKeyType.getSymmetricCrypto(exchangeKey.getBytes());
        } else {
            symmetricCrypto = methodAnnotation.exchangeKeyType().getSymmetricCrypto(methodAnnotation.key().getBytes());
        }
        final SymmetricCrypto finalSymmetricCrypto = symmetricCrypto;
        return new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                String decryptStr = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)Charset.defaultCharset());
                log.debug("\u3010\u5bc6\u94a5\u4ea4\u6362-\u89e3\u5bc6\u3011decryptStr={}", (Object)decryptStr);
                return new ByteArrayInputStream(finalSymmetricCrypto.decrypt(decryptStr));
            }

            public HttpHeaders getHeaders() {
                return inputMessage.getHeaders();
            }
        };
    }
}

