/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.annotation.key.exchange;

import ai.yue.library.base.crypto.annotation.key.exchange.ResponseEncrypt;
import ai.yue.library.base.crypto.constant.key.exchange.ExchangeKeyEnum;
import ai.yue.library.base.crypto.dao.key.exchange.KeyExchangeStorage;
import ai.yue.library.base.crypto.util.EncryptParamUtils;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.web.util.servlet.ServletUtils;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@ConditionalOnClass(value={HttpServletRequest.class})
public class ResponseEncryptHandler<T>
implements ResponseBodyAdvice<T> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(ResponseEncrypt.class) && returnType.getMethod().getReturnType() == Result.class;
    }

    public T beforeBodyWrite(T body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return body;
        }
        Result result = (Result)body;
        if (!result.isFlag()) {
            return body;
        }
        ResponseEncrypt methodAnnotation = (ResponseEncrypt)returnType.getMethodAnnotation(ResponseEncrypt.class);
        boolean enableExchangeKeyEncrypt = methodAnnotation.enableExchangeKeyEncrypt();
        SymmetricCrypto symmetricCrypto = null;
        if (enableExchangeKeyEncrypt) {
            String keyExchangeStorageKey = null;
            HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
            if (methodAnnotation.useAuthTokenGetExchangeKey()) {
                keyExchangeStorageKey = ServletUtils.getAuthToken((HttpServletRequest)servletRequest);
            } else {
                String headerNameGetExchangeKey = methodAnnotation.headerNameGetExchangeKey();
                String paramNameGetExchangeKey = methodAnnotation.paramNameGetExchangeKey();
                keyExchangeStorageKey = servletRequest.getHeader(headerNameGetExchangeKey);
                if (StrUtil.isBlank((CharSequence)keyExchangeStorageKey)) {
                    keyExchangeStorageKey = servletRequest.getParameter(paramNameGetExchangeKey);
                }
            }
            if (StrUtil.isBlank((CharSequence)keyExchangeStorageKey)) {
                throw new ParamException("\u672a\u80fd\u83b7\u53d6\u5230\u4ea4\u6362\u5bc6\u94a5\uff1a1. \u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u8fdb\u884c\u8fc7\u5bc6\u94a5\u4ea4\u6362\uff0c2. \u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165keyExchangeStorageKey\uff08\u5982\uff1atoken\u522b\u540d\u3001UUID\u7b49\uff09\u5e76\u6307\u5b9a\u4e86\u5bf9\u5e94\u7684Get\u65b9\u5f0f\u3002");
            }
            KeyExchangeStorage keyExchangeStorage = (KeyExchangeStorage)SpringUtils.getBean(KeyExchangeStorage.class);
            String exchangeKey = keyExchangeStorage.getExchangeKey(keyExchangeStorageKey);
            ExchangeKeyEnum exchangeKeyType = methodAnnotation.exchangeKeyType();
            symmetricCrypto = exchangeKeyType.getSymmetricCrypto(exchangeKey.getBytes());
        } else {
            symmetricCrypto = methodAnnotation.exchangeKeyType().getSymmetricCrypto(methodAnnotation.key().getBytes());
        }
        String encryptedBase64 = symmetricCrypto.encryptBase64(EncryptParamUtils.toEncryptByte(result.getData()));
        result.setData((Object)encryptedBase64);
        return body;
    }
}

