/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.config;

import ai.yue.library.base.crypto.annotation.key.exchange.RequestDecryptHandler;
import ai.yue.library.base.crypto.annotation.key.exchange.ResponseEncryptHandler;
import ai.yue.library.base.crypto.config.properties.KeyExchangeProperties;
import ai.yue.library.base.crypto.controller.key.exchange.KeyExchangeController;
import ai.yue.library.base.crypto.dao.key.exchange.MapKeyExchangeStorage;
import ai.yue.library.base.crypto.dao.key.exchange.RedisKeyExchangeStorage;
import ai.yue.library.base.crypto.dto.key.exchange.KeyExchangeDTO;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.data.redis.client.Redis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@Import(value={KeyExchangeController.class, RequestDecryptHandler.class, ResponseEncryptHandler.class})
@EnableConfigurationProperties(value={KeyExchangeProperties.class})
@ConditionalOnProperty(prefix="yue.crypto.key-exchange", name={"enabled"}, havingValue="true")
public class KeyExchangeConfig {
    private static final Logger log = LoggerFactory.getLogger(KeyExchangeConfig.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yue.crypto.key-exchange", name={"key-exchange-storage-type"}, havingValue="LOCAL_MAP", matchIfMissing=true)
    public MapKeyExchangeStorage mapKeyExchangeStorage() {
        return new MapKeyExchangeStorage();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Redis.class, RedisConnectionFactory.class})
    @ConditionalOnProperty(prefix="yue.crypto.key-exchange", name={"key-exchange-storage-type"}, havingValue="REDIS")
    public RedisKeyExchangeStorage redisKeyExchangeStorage() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)SpringUtils.getBean(RedisConnectionFactory.class));
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return new RedisKeyExchangeStorage((RedisTemplate<String, KeyExchangeDTO>)redisTemplate);
    }
}

