/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.constant.key.exchange;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.symmetric.SymmetricCrypto;

public enum ExchangeKeyEnum {
    RSA_AES{

        @Override
        public AbstractAsymmetricCrypto getAsymmetricCrypto() {
            return SecureUtil.rsa();
        }

        @Override
        public AbstractAsymmetricCrypto getAsymmetricCrypto(String privateKeyBase64, String publicKeyBase64) {
            return SecureUtil.rsa((String)privateKeyBase64, (String)publicKeyBase64);
        }

        @Override
        public SymmetricCrypto getSymmetricCrypto(byte[] key) {
            return SecureUtil.aes((byte[])key);
        }
    }
    ,
    SM2_SM4{

        @Override
        public AbstractAsymmetricCrypto getAsymmetricCrypto() {
            return SmUtil.sm2();
        }

        @Override
        public AbstractAsymmetricCrypto getAsymmetricCrypto(String privateKeyBase64, String publicKeyBase64) {
            return SmUtil.sm2((String)privateKeyBase64, (String)publicKeyBase64);
        }

        @Override
        public SymmetricCrypto getSymmetricCrypto(byte[] key) {
            return SmUtil.sm4((byte[])key);
        }
    };


    public abstract AbstractAsymmetricCrypto getAsymmetricCrypto();

    public abstract AbstractAsymmetricCrypto getAsymmetricCrypto(String var1, String var2);

    public abstract SymmetricCrypto getSymmetricCrypto(byte[] var1);
}

