/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.crypto.dao.key.exchange;

import ai.yue.library.base.crypto.dao.key.exchange.KeyExchangeStorage;
import ai.yue.library.base.crypto.dto.key.exchange.KeyExchangeDTO;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.data.redis.client.Redis;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisKeyExchangeStorage
implements KeyExchangeStorage {
    private static final String REDIS_PREFIX = Redis.separatorJoin((String[])new String[]{"yue.crypto", "key-exchange"});
    private RedisTemplate<String, KeyExchangeDTO> redisTemplate;

    private String getRedisKey(String storageKey) {
        return Redis.separatorJoin((String[])new String[]{REDIS_PREFIX, storageKey});
    }

    private KeyExchangeDTO getNotEmpty(String storageKey) {
        KeyExchangeDTO keyExchangeDTO = (KeyExchangeDTO)this.redisTemplate.opsForValue().get((Object)this.getRedisKey(storageKey));
        if (keyExchangeDTO == null) {
            throw new ParamException("\u672a\u80fd\u83b7\u53d6\u5230\u4ea4\u6362\u5bc6\u94a5\uff1a1. \u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u8fdb\u884c\u8fc7\u5bc6\u94a5\u4ea4\u6362\uff0c2. \u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165keyExchangeStorageKey\uff08\u5982\uff1atoken\u522b\u540d\u3001UUID\u7b49\uff09\u5e76\u6307\u5b9a\u4e86\u5bf9\u5e94\u7684Get\u65b9\u5f0f\u3002");
        }
        return keyExchangeDTO;
    }

    private KeyExchangeDTO getOrInit(String storageKey) {
        KeyExchangeDTO keyExchangeDTO = (KeyExchangeDTO)this.redisTemplate.opsForValue().get((Object)this.getRedisKey(storageKey));
        keyExchangeDTO = keyExchangeDTO == null ? new KeyExchangeDTO() : keyExchangeDTO;
        return keyExchangeDTO;
    }

    @Override
    public String getPrivateKeyBase64(String storageKey) {
        return this.getNotEmpty(storageKey).getPrivateKeyBase64();
    }

    @Override
    public void setPrivateKeyBase64(String storageKey, String privateKeyBase64) {
        KeyExchangeDTO keyExchangeDTO = this.getOrInit(storageKey);
        keyExchangeDTO.setPrivateKeyBase64(privateKeyBase64);
        this.redisTemplate.opsForValue().set((Object)this.getRedisKey(storageKey), (Object)keyExchangeDTO);
    }

    @Override
    public String getExchangeKey(String storageKey) {
        return this.getNotEmpty(storageKey).getExchangeKey();
    }

    @Override
    public void setExchangeKey(String storageKey, String exchangeKey) {
        KeyExchangeDTO keyExchangeDTO = this.getOrInit(storageKey);
        keyExchangeDTO.setExchangeKey(exchangeKey);
        this.redisTemplate.opsForValue().set((Object)this.getRedisKey(storageKey), (Object)keyExchangeDTO);
    }

    @Override
    public void addAlias(String storageKey, String storageKeyAlias) {
        KeyExchangeDTO keyExchangeDTO = this.getOrInit(storageKey);
        this.redisTemplate.opsForValue().set((Object)this.getRedisKey(storageKeyAlias), (Object)keyExchangeDTO);
    }

    public RedisKeyExchangeStorage(RedisTemplate<String, KeyExchangeDTO> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

