package ai.yue.library.base.validation.annotation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;

/**
 * @author	ylyue
 * @since	2019年5月8日
 */
public class ChineseValidator implements ConstraintValidator<Chinese, Object> {

	private boolean notNull;
	
	@Override
	public void initialize(Chinese constraintAnnotation) {
		this.notNull = constraintAnnotation.notNull();
	}
	
	@Override
	public boolean isValid(Object value, ConstraintValidatorContext context) {
		String validValue = null;
		if ((CharUtil.isChar(value) && !CharUtil.isBlankChar((char) value))
				|| (value instanceof String && StrUtil.isNotBlank((String) value))) {
			validValue = StrUtil.toString(value);
		}
		
		if (StringUtils.isNotBlank(validValue)) {
			return Validator.isChinese(validValue);
		}
		
		if (notNull) {
			return false;
		}
		
		return true;
	}
	
}
