/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.handler;

import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.exception.DecryptException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.JSONObjectException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultInfo;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AllExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AllExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result<?> exceptionHandler(Exception e) {
        e.printStackTrace();
        return ResultInfo.error();
    }

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result<?> result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException(e);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={ClientFallbackException.class})
    public Result<?> clientFallbackExceptionHandler(ClientFallbackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.client_fallback();
    }

    @ResponseBody
    @ExceptionHandler(value={AttackException.class})
    public Result<?> attackExceptionHandler(AttackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.attack(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public Result<?> paramVoidExceptionHandler() {
        return ResultInfo.param_void();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public Result<?> paramExceptionHandler(ParamException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.param_check_not_pass(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={JSONObjectException.class})
    public Result<?> jsonObjectExceptionHandler(JSONObjectException e) {
        log.error("\u3010JSONObject\u9519\u8bef\u3011\u683c\u5f0f\u5316JSON\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException(e);
        return ResultInfo.json_parse_error();
    }

    @ResponseBody
    @ExceptionHandler(value={DecryptException.class})
    public Result<?> decryptExceptionHandler(DecryptException e) {
        log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException(e);
        return ResultInfo.decrypt_error();
    }

    @ResponseBody
    @ExceptionHandler(value={DBException.class})
    public Result<?> dbExceptionHandler(DBException e) {
        e.printStackTrace();
        return ResultInfo.db_error();
    }

    @ResponseBody
    @ExceptionHandler(value={ForbiddenException.class})
    public Result<?> forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.forbidden();
    }

    @ResponseBody
    @ExceptionHandler(value={LoginException.class})
    public Result<?> loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.unauthorized();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public void authorizeExceptionHandler(AuthorizeException e) throws IOException {
        ExceptionUtils.printException(e);
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.sendRedirect("");
    }
}

