/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.exception.DecryptException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class AESUtils {
    private static final Logger log = LoggerFactory.getLogger(AESUtils.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static String encrypt(String content, String keyt) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, AESUtils.getSecretKey(keyt));
            byte[] encryptedData = cipher.doFinal(byteContent);
            return Base64Utils.encodeToString((byte[])encryptedData);
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String content, String keyt) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AESUtils.getSecretKey(keyt));
            byte[] encryptedData = Base64Utils.decodeFromString((String)content);
            byte[] decryptedData = cipher.doFinal(encryptedData);
            return new String(decryptedData, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u3010AES\u89e3\u5bc6\u9519\u8bef\u3011\u89e3\u5bc6\u5185\u5bb9 = {}", (Object)content);
            throw new DecryptException(e.getMessage());
        }
    }

    private static SecretKeySpec getSecretKey(String password) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(password.getBytes());
            kg.init(128, secureRandom);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("AES\u751f\u6210\u52a0\u5bc6\u79d8\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff1a", (Throwable)e);
            return null;
        }
    }
}

