/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import cn.hutool.core.lang.Console;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUtils {
    public static final String HTTP_TCP_NAME = "http://";
    public static final String HTTPS_TCP_NAME = "https://";
    public static final String POINTCUT = "@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)";

    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static HttpSession getSession() {
        return HttpUtils.getRequest().getSession();
    }

    public static String getServerURL() {
        HttpServletRequest request = HttpUtils.getRequest();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        return HTTP_TCP_NAME + serverName + ":" + serverPort + contextPath;
    }

    public static void printRequest() {
        HttpServletRequest request = HttpUtils.getRequest();
        Console.error((Object)"========\u5f00\u59cb-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u4fe1\u606f\uff1a");
        Console.log((String)"RemoteAddr\uff1a{}", (Object[])new Object[]{request.getRemoteAddr()});
        Console.log((String)"Method\uff1a{}", (Object[])new Object[]{request.getMethod()});
        Console.log((String)"AuthType\uff1a{}", (Object[])new Object[]{request.getAuthType()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u670d\u52a1\u5668\u4fe1\u606f\uff1a");
        Console.log((String)"ServerURL\uff1a{}", (Object[])new Object[]{HttpUtils.getServerURL()});
        Console.log((String)"RequestURL\uff1a{}", (Object[])new Object[]{request.getRequestURL()});
        Console.log((String)"RequestedSessionId\uff1a{}", (Object[])new Object[]{request.getRequestedSessionId()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a");
        Console.log((String)"QueryString\uff1a{}", (Object[])new Object[]{request.getQueryString()});
        Console.log((String)"ParameterMap\uff1a{}", (Object[])new Object[]{JSONObject.toJSONString((Object)request.getParameterMap())});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u5934\uff1a");
        Console.log((Object)"Headers\uff1a");
        request.getHeaderNames().asIterator().forEachRemaining(headerName -> {
            StringBuilder headerValues = new StringBuilder();
            request.getHeaders(headerName).asIterator().forEachRemaining(headerValue -> headerValues.append((String)headerValue));
            Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{headerName, headerValues});
        });
        Console.log();
        Console.log((Object)"Cookies\uff1a");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{cookie.getName(), cookie.getValue()});
            }
        }
        Console.error((Object)"========\u7ed3\u675f-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
    }
}

