/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.ipo.ParamFormatIPO;
import ai.yue.library.base.ipo.ParamValidateIPO;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.view.ResultInfo;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParamUtils {
    static final String PARAM_PREFIX_MUST = "\u3010\u5fc5\u4f20\u53c2\u6570\u3011\uff1a";
    static final String PARAM_PREFIX_CAN = "\u3010\u53ef\u9009\u53c2\u6570\u3011\uff1a";

    public static void paramFormatBoolean(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getBoolean(key));
        }
    }

    public static void paramFormatBigDecimal(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getBigDecimal(key));
        }
    }

    public static void paramFormatJSONObject(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getJSONObject(key));
        }
    }

    public static void paramFormatJSONArray(JSONObject paramJson, String ... keys) {
        for (String key : keys) {
            paramJson.replace((Object)key, (Object)paramJson.getJSONArray(key));
        }
    }

    public static void paramFormatObject(JSONObject paramJson, List<ParamFormatIPO> paramFormatIPOList) {
        for (ParamFormatIPO paramFormatIPO : paramFormatIPOList) {
            String key = paramFormatIPO.getKey();
            Class<?> clazz = paramFormatIPO.getClazz();
            paramJson.replace((Object)key, paramJson.getObject(key, clazz));
        }
    }

    public static void paramFormat(JSONObject paramJson, String[] booleanKeys, String[] decimalKeys, String[] jsonObjectKeys, String[] jsonArrayKeys) {
        if (!StringUtils.isEmptys(booleanKeys)) {
            ParamUtils.paramFormatBoolean(paramJson, booleanKeys);
        }
        if (!StringUtils.isEmptys(decimalKeys)) {
            ParamUtils.paramFormatBigDecimal(paramJson, decimalKeys);
        }
        if (!StringUtils.isEmptys(jsonObjectKeys)) {
            ParamUtils.paramFormatJSONObject(paramJson, jsonObjectKeys);
        }
        if (!StringUtils.isEmptys(jsonArrayKeys)) {
            ParamUtils.paramFormatJSONArray(paramJson, jsonArrayKeys);
        }
    }

    public static void paramValidate(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (!ObjectUtils.isNull((Object)object)) continue;
            throw new ResultException(ResultInfo.param_check_not_pass());
        }
    }

    public static void paramValidate(JSONObject paramJson, String[] mustContainKeys, String ... canContainKeys) {
        if (!MapUtils.isKeys((Map<String, Object>)paramJson, mustContainKeys, canContainKeys)) {
            throw new ParamException(PARAM_PREFIX_MUST + Arrays.toString(mustContainKeys) + "\uff0c\u3010\u53ef\u9009\u53c2\u6570\u3011\uff1a" + Arrays.toString(canContainKeys));
        }
    }

    public static void paramValidate(List<JSONObject> paramList, String[] mustContainKeys, String ... canContainKeys) {
        if (paramList.isEmpty()) {
            throw new ParamVoidException();
        }
        for (JSONObject paramJson : paramList) {
            ParamUtils.paramValidate(paramJson, mustContainKeys, canContainKeys);
        }
    }

    public static void paramValidate(ParamValidateIPO paramValidateIPO) {
        JSONObject paramJson = paramValidateIPO.getParamJson();
        String cellphoneKey = paramValidateIPO.getCellphoneKey();
        String emailKey = paramValidateIPO.getEmailKey();
        String idCardNumberKey = paramValidateIPO.getIdCardNumberKey();
        String cellphone = paramJson.getString(cellphoneKey);
        if (!StringUtils.isEmpty((CharSequence)cellphone) && !ParamUtils.isCellphoneValidate(cellphone)) {
            throw new ResultException(ResultInfo.cellphone_error());
        }
        String email = paramJson.getString(emailKey);
        if (!StringUtils.isEmpty((CharSequence)email) && !ParamUtils.isEmailValidate(email)) {
            throw new ResultException(ResultInfo.email_error());
        }
        String idCardNumber = paramJson.getString(idCardNumberKey);
        if (!StringUtils.isEmpty((CharSequence)idCardNumber) && !ParamUtils.isIdCardNumberValidate(idCardNumber)) {
            throw new ResultException(ResultInfo.id_card_number_error());
        }
    }

    static boolean isEmailValidate(String email) {
        String regex = "^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
        return email.matches(regex);
    }

    static boolean isIdCardNumberValidate(String id) {
        String regex = "^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
        return id.matches(regex);
    }

    static boolean isCellphoneValidate(String cellphone) {
        String regex = "^((13[0-9])|(14[5|7|9])|(15([0-3]|[5-9]))|(17[0-8])|(18[0,1,2,3,5-9]))\\d{8}$";
        return cellphone.matches(regex);
    }

    boolean isTelephoneValidate(String telephone) {
        String regex = "^(0\\d{2}-\\d{8}(-\\d{1,4})?)|(0\\d{3}-\\d{7,8}(-\\d{1,4})?)$";
        return telephone.matches(regex);
    }

    public static String cellphoneEncrypt(String cellphone) {
        if (cellphone.length() == 11) {
            return cellphone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        if (cellphone.length() > 4) {
            return cellphone.replaceAll("(\\d{2})\\d+(\\d{2})", "$1****$2");
        }
        return cellphone.replaceAll("(\\d{1})\\d+(\\d{1})", "$1**$2");
    }
}

