/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.handler;

import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.util.HttpUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultInfo;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result<?> exceptionHandler(Exception e) {
        e.printStackTrace();
        return ResultInfo.error(e.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result<?> result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException(e);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={ClientFallbackException.class})
    public Result<?> clientFallbackExceptionHandler(ClientFallbackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.client_fallback();
    }

    @ResponseBody
    @ExceptionHandler(value={AttackException.class})
    public Result<?> attackExceptionHandler(AttackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.attack(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public Result<?> paramVoidExceptionHandler() {
        return ResultInfo.param_void();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public Result<?> paramExceptionHandler(ParamException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.param_check_not_pass(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        String uri = HttpUtils.getRequest().getRequestURI();
        Console.error((String)"uri={}", (Object[])new Object[]{uri});
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        return ResultInfo.param_check_not_pass(paramHint.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Result<?> validateExceptionHandler(ValidateException e) {
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.param_check_not_pass(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ConvertException.class})
    public Result<?> convertExceptionHandler(ConvertException e) {
        log.error("\u3010\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\u3011\u8f6c\u6362\u7c7b\u578b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.type_convert_error(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamDecryptException.class})
    public Result<?> paramDecryptExceptionHandler(ParamDecryptException e) {
        log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException(e);
        return ResultInfo.param_decrypt_error();
    }

    @ResponseBody
    @ExceptionHandler(value={DBException.class})
    public Result<?> dbExceptionHandler(DBException e) {
        e.printStackTrace();
        return ResultInfo.db_error();
    }

    @ResponseBody
    @ExceptionHandler(value={ForbiddenException.class})
    public Result<?> forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.forbidden();
    }

    @ResponseBody
    @ExceptionHandler(value={LoginException.class})
    public Result<?> loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.unauthorized();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public void authorizeExceptionHandler(AuthorizeException e) throws IOException {
        ExceptionUtils.printException(e);
        HttpServletResponse response = HttpUtils.getResponse();
        response.sendRedirect("");
    }
}

