/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.view;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.HttpUtils;
import ai.yue.library.base.util.ListUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -3830508963654505583L;
    private Integer code;
    private String msg;
    private Boolean flag;
    private T data;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long count;

    public void successValidate() {
        if (!this.flag.booleanValue()) {
            throw new ResultException(this);
        }
    }

    public <D> D getData(Class<D> clazz) {
        return (D)TypeUtils.castToJavaBean(this.data, clazz);
    }

    public JSONObject dataToJSONObject() {
        return Convert.toJSONObject(this.data);
    }

    public JSONArray dataToJSONArray() {
        return Convert.toJSONArray(this.data);
    }

    public List<JSONObject> dataToJsonList() {
        List dataTemp;
        if (this.data instanceof List && ListUtils.isNotEmpty(dataTemp = (List)this.data) && dataTemp.get(0) instanceof JSONObject) {
            return (List)this.data;
        }
        return ListUtils.toJsonList(this.dataToJSONArray());
    }

    @Deprecated
    public List<JSONObject> dataToJSONList() {
        return this.dataToJsonList();
    }

    public Boolean dataToBoolean() {
        if (this.data == null) {
            return null;
        }
        return TypeUtils.castToBoolean(this.data);
    }

    public Integer dataToInteger() {
        return TypeUtils.castToInt(this.data);
    }

    public Long dataToLong() {
        return TypeUtils.castToLong(this.data);
    }

    public Double dataToDouble() {
        return TypeUtils.castToDouble(this.data);
    }

    public BigDecimal dataToBigDecimal() {
        return TypeUtils.castToBigDecimal(this.data);
    }

    public BigInteger dataToBigInteger() {
        return TypeUtils.castToBigInteger(this.data);
    }

    public String dataToString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    public String dataToJSONString() {
        if (this.data == null) {
            return null;
        }
        return JSONObject.toJSONString(this.data);
    }

    public java.util.Date dataToDate() {
        return TypeUtils.castToDate(this.data);
    }

    public Date dataToSqlDate() {
        return TypeUtils.castToSqlDate(this.data);
    }

    public Timestamp dataToTimestamp() {
        return TypeUtils.castToTimestamp(this.data);
    }

    public void response() {
        HttpServletResponse response = HttpUtils.getResponse();
        response.setContentType("application/json; charset=utf-8");
        try {
            PrintWriter writer = response.getWriter();
            writer.print(JSONObject.toJSONString((Object)this));
            writer.close();
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public ResultBuilder<T> toBuilder() {
        return new ResultBuilder().code(this.code).msg(this.msg).flag(this.flag).data(this.data).count(this.count);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Boolean getFlag() {
        return this.flag;
    }

    public T getData() {
        return this.data;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setFlag(Boolean flag) {
        this.flag = flag;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Boolean this$flag = this.getFlag();
        Boolean other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        return !(this$count == null ? other$count != null : !((Object)this$count).equals(other$count));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Boolean $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", flag=" + this.getFlag() + ", data=" + this.getData() + ", count=" + this.getCount() + ")";
    }

    public Result() {
    }

    public Result(Integer code, String msg, Boolean flag, T data, Long count) {
        this.code = code;
        this.msg = msg;
        this.flag = flag;
        this.data = data;
        this.count = count;
    }

    public static class ResultBuilder<T> {
        private Integer code;
        private String msg;
        private Boolean flag;
        private T data;
        private Long count;

        ResultBuilder() {
        }

        public ResultBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ResultBuilder<T> flag(Boolean flag) {
            this.flag = flag;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultBuilder<T> count(Long count) {
            this.count = count;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.code, this.msg, this.flag, this.data, this.count);
        }

        public String toString() {
            return "Result.ResultBuilder(code=" + this.code + ", msg=" + this.msg + ", flag=" + this.flag + ", data=" + this.data + ", count=" + this.count + ")";
        }
    }
}

