/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapUtils
extends MapUtil {
    public static final JSONObject FINAL_EMPTY_JSON = new JSONObject();

    public static boolean isKeys(Map<String, Object> paramMap, String[] mustContainKeys, String ... canContainKeys) {
        for (String key : mustContainKeys) {
            if (paramMap.containsKey(key)) continue;
            return false;
        }
        if (StringUtils.isEmptys(canContainKeys)) {
            return true;
        }
        int keySize = mustContainKeys.length + canContainKeys.length;
        if (paramMap.size() > keySize) {
            return false;
        }
        int paramMapCanContainKeysLength = 0;
        for (String key : canContainKeys) {
            if (!paramMap.containsKey(key)) continue;
            ++paramMapCanContainKeysLength;
        }
        return paramMapCanContainKeysLength + mustContainKeys.length == paramMap.size();
    }

    public static boolean isKeysEqual(Map<String, Object> paramMap, String[] keys) {
        if (paramMap.size() != keys.length) {
            return false;
        }
        for (String key : keys) {
            if (paramMap.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainsOneOfKey(Map<String, Object> paramMap, String[] keys) {
        for (String key : keys) {
            if (!paramMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMapsKeys(Map<String, Object>[] paramMaps, String[] keys) {
        return MapUtils.isKeys(paramMaps[0], keys, new String[0]);
    }

    public static boolean isEmptys(Map<String, Object>[] paramMaps) {
        return null == paramMaps || paramMaps.length == 0 || paramMaps[0].isEmpty();
    }

    public static boolean isStringValueEmpty(Map<String, Object> paramMap) {
        if (paramMap.isEmpty()) {
            return true;
        }
        for (Object value : paramMap.values()) {
            if (null != value && !"".equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void trimStringValues(Map<String, Object> paramMap) {
        for (String key : paramMap.keySet()) {
            String value;
            String str = MapUtils.getString(paramMap, key);
            if (str.equals(value = str.trim())) continue;
            paramMap.replace(key, value);
        }
    }

    public static void remove(Map<String, Object> paramMap, String[] keys) {
        for (String key : keys) {
            paramMap.remove(key);
        }
    }

    public static void removeEmpty(Map<String, Object> paramMap) {
        Iterator<Map.Entry<String, Object>> iter = paramMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (!ObjectUtils.isNull((Object)value)) continue;
            iter.remove();
        }
    }

    public static void removeBlankStr(Map<String, Object> paramMap) {
        Iterator<Map.Entry<String, Object>> iter = paramMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (!StrUtil.isBlankIfStr((Object)value)) continue;
            iter.remove();
        }
    }

    public static void replaceKey(Map<String, Object> paramMap, String key, String replaceKey) {
        Object value = paramMap.get(key);
        paramMap.put(replaceKey, value);
        paramMap.remove(key);
    }

    public static List<String> keyList(Map<String, Object> paramMap) {
        ArrayList<String> list = new ArrayList<String>();
        paramMap.keySet().forEach(action -> list.add((String)action));
        return list;
    }

    public static JSONObject getJSONObject(Map<String, Object> paramMap, String ... keys) {
        JSONObject paramJson = new JSONObject(paramMap);
        if (!MapUtils.isContainsOneOfKey((Map<String, Object>)paramJson, keys)) {
            return null;
        }
        JSONObject resultJSON = new JSONObject();
        for (String key : keys) {
            Object value = paramJson.get((Object)key);
            if (value == null) continue;
            resultJSON.put(key, value);
        }
        return resultJSON;
    }

    public static <T> T getObject(Map<?, ?> paramMap, Object key, Class<T> clazz) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            return ObjectUtils.toObject(answer, clazz);
        }
        return null;
    }

    public static Number getNumber(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getString(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Integer getInteger(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return answer.intValue();
    }

    public static Long getLong(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return answer.longValue();
    }

    public static Double getDouble(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return answer.doubleValue();
    }

    public static BigDecimal getBigDecimal(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return new BigDecimal((Double)answer);
        }
        return new BigDecimal(answer.doubleValue());
    }

    public static JSONObject getJSONObject(Map<?, ?> paramMap, String key) {
        Object value = paramMap.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            return JSON.parseObject((String)((String)value));
        }
        return (JSONObject)JSON.toJSON(value);
    }

    public static JSONArray getJSONArray(Map<?, ?> paramMap, String key) {
        Object value = paramMap.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof String) {
            return (JSONArray)JSON.parse((String)((String)value));
        }
        return (JSONArray)JSON.toJSON(value);
    }
}

