/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config;

import ai.yue.library.base.config.factory.HttpsRequestFactory;
import ai.yue.library.base.config.properties.ConstantProperties;
import ai.yue.library.base.config.properties.CorsProperties;
import ai.yue.library.base.config.properties.RestProperties;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={ConstantProperties.class, RestProperties.class, CorsProperties.class})
public class BeanAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(BeanAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public ClientHttpRequestFactory httpsRequestFactory(RestProperties restProperties) {
        Integer readTimeout;
        HttpsRequestFactory factory = new HttpsRequestFactory();
        Integer connectTimeout = restProperties.getConnectTimeout();
        if (connectTimeout != null) {
            factory.setConnectTimeout(connectTimeout);
        }
        if ((readTimeout = restProperties.getReadTimeout()) != null) {
            factory.setReadTimeout(readTimeout);
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-HTTPS\u5ba2\u6237\u7aef\u3011\u6b63\u5728\u521d\u59cb\u5316Bean\uff1aRestTemplate ...");
        return new RestTemplate(factory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yue.cors", name={"allow"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsFilter(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setAllowedHeaders(Arrays.asList("*"));
        config.setAllowedMethods(Arrays.asList("*"));
        config.setAllowedOrigins(Arrays.asList("*"));
        config.setMaxAge(Long.valueOf(3600L));
        List<String> exposedHeaders = corsProperties.getExposedHeaders();
        if (exposedHeaders != null) {
            config.setExposedHeaders(exposedHeaders);
        } else {
            config.addExposedHeader("token");
        }
        source.registerCorsConfiguration("/**", config);
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u8de8\u57df\u3011\u6b63\u5728\u521d\u59cb\u5316Bean\uff1aCorsFilter ...");
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

