/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    public static void set(String key, String value, int timeout) {
        HttpServletResponse response = HttpUtils.getResponse();
        Cookie cookie = new Cookie(key, value);
        cookie.setPath("/");
        cookie.setMaxAge(timeout);
        response.addCookie(cookie);
    }

    public static Cookie get(String key) {
        Map<String, Cookie> cookieMap = CookieUtils.readCookieMap();
        if (cookieMap.containsKey(key)) {
            return cookieMap.get(key);
        }
        return null;
    }

    private static Map<String, Cookie> readCookieMap() {
        HttpServletRequest request = HttpUtils.getRequest();
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

