/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;

public final class ObjectUtils
extends ObjectUtil {
    public static <T extends Serializable> T objectClone(T obj) {
        Serializable cloneObj = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream obs = new ObjectOutputStream(out);
            obs.writeObject(obj);
            obs.close();
            ByteArrayInputStream ios = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(ios);
            cloneObj = (Serializable)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)cloneObj;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2 || obj1.equals(obj2)) {
            return true;
        }
        Class<?> clazz = obj1.getClass();
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                byte value2;
                byte value1 = Byte.parseByte(obj1.toString());
                return value1 == (value2 = Byte.parseByte(obj2.toString()));
            }
            if (clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class) {
                int value2;
                int value1 = Integer.parseInt(obj1.toString());
                return value1 == (value2 = Integer.parseInt(obj2.toString()));
            }
            if (clazz == Long.TYPE || clazz == Long.class || clazz == BigInteger.class) {
                long value2;
                long value1 = Long.parseLong(obj1.toString());
                return value1 == (value2 = Long.parseLong(obj2.toString()));
            }
            if (clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == BigDecimal.class) {
                double value2;
                double value1 = Double.parseDouble(obj1.toString());
                return value1 == (value2 = Double.parseDouble(obj2.toString()));
            }
            if (clazz == Character.TYPE || clazz == Character.class || clazz == String.class) {
                return obj1.toString().equals(obj2);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static <T> T toObject(Object obj, Class<T> clazz) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            if (clazz == LocalDate.class) {
                return (T)LocalDate.parse(str);
            }
            if (clazz == LocalDateTime.class) {
                return (T)LocalDateTime.parse(str);
            }
        }
        return (T)TypeUtils.castToJavaBean((Object)obj, clazz);
    }

    public static <T> T toJavaObject(Object obj, Class<T> clazz) {
        return (T)JSONObject.toJavaObject((JSON)ObjectUtils.toJSONObject(obj), clazz);
    }

    public static JSONObject toJSONObject(Object obj) {
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        if (obj instanceof String) {
            return JSONObject.parseObject((String)((String)obj));
        }
        return (JSONObject)JSON.toJSON((Object)obj);
    }

    public static JSONArray toJSONArray(Object obj) {
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        if (obj instanceof String) {
            return (JSONArray)JSON.parse((String)((String)obj));
        }
        return (JSONArray)JSON.toJSON((Object)obj);
    }
}

