/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.handler;

import ai.yue.library.base.config.handler.ExceptionHandlerProperties;
import ai.yue.library.base.exception.AttackException;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ClientFallbackException;
import ai.yue.library.base.exception.DBException;
import ai.yue.library.base.exception.ForbiddenException;
import ai.yue.library.base.exception.LoginException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.util.servlet.ServletUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultInfo;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@EnableConfigurationProperties(value={ExceptionHandlerProperties.class})
@ConditionalOnProperty(prefix="yue.exception-handler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ExceptionHandlerConfig {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerConfig.class);

    @PostConstruct
    private void init() {
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-\u5168\u5c40\u7edf\u4e00\u5f02\u5e38\u5904\u7406\u3011\u62e6\u622a\u6240\u6709Controller\u5c42\u5f02\u5e38\uff0c\u8fd4\u56deHTTP\u8bf7\u6c42\u6700\u5916\u5c42\u5bf9\u8c61 ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result<?> exceptionHandler(Exception e) {
        e.printStackTrace();
        return ResultInfo.error(e.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result<?> result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException(e);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={ClientFallbackException.class})
    public Result<?> clientFallbackExceptionHandler(ClientFallbackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.client_fallback();
    }

    @ResponseBody
    @ExceptionHandler(value={AttackException.class})
    public Result<?> attackExceptionHandler(AttackException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.attack(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public Result<?> paramVoidExceptionHandler() {
        return ResultInfo.param_void();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public Result<?> paramExceptionHandler(ParamException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.param_check_not_pass(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        String uri = ServletUtils.getRequest().getRequestURI();
        Console.error((String)"uri={}", (Object[])new Object[]{uri});
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        return ResultInfo.param_check_not_pass(paramHint.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Result<?> validateExceptionHandler(ValidateException e) {
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.param_check_not_pass(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ConvertException.class})
    public Result<?> convertExceptionHandler(ConvertException e) {
        log.error("\u3010\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\u3011\u8f6c\u6362\u7c7b\u578b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.type_convert_error(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamDecryptException.class})
    public Result<?> paramDecryptExceptionHandler(ParamDecryptException e) {
        log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException(e);
        return ResultInfo.param_decrypt_error();
    }

    @ResponseBody
    @ExceptionHandler(value={DBException.class})
    public Result<?> dbExceptionHandler(DBException e) {
        e.printStackTrace();
        return ResultInfo.db_error();
    }

    @ResponseBody
    @ExceptionHandler(value={ForbiddenException.class})
    public Result<?> forbiddenExceptionHandler(ForbiddenException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.forbidden();
    }

    @ResponseBody
    @ExceptionHandler(value={LoginException.class})
    public Result<?> loginExceptionHandler(LoginException e) {
        ExceptionUtils.printException(e);
        return ResultInfo.unauthorized();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public void authorizeExceptionHandler(AuthorizeException e) throws IOException {
        ExceptionUtils.printException(e);
        HttpServletResponse response = ServletUtils.getResponse();
        response.sendRedirect("");
    }
}

