/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.view;

import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultEnum;

public class ResultInfo {
    private static Result<?> error(Integer code, String msg) {
        return Result.builder().code(code).msg(msg).flag(false).build();
    }

    private static <T> Result<T> error(Integer code, String msg, T data) {
        return new Result().toBuilder().code(code).msg(msg).flag(false).data(data).build();
    }

    public static Result<?> attack() {
        return ResultInfo.error(ResultEnum.ATTACK.getCode(), ResultEnum.ATTACK.getMsg());
    }

    public static <T> Result<T> attack(T data) {
        return ResultInfo.error(ResultEnum.ATTACK.getCode(), ResultEnum.ATTACK.getMsg(), data);
    }

    public static Result<?> unauthorized() {
        return ResultInfo.error(ResultEnum.UNAUTHORIZED.getCode(), ResultEnum.UNAUTHORIZED.getMsg());
    }

    public static Result<?> logged_in() {
        return ResultInfo.error(ResultEnum.LOGGED_IN.getCode(), ResultEnum.LOGGED_IN.getMsg());
    }

    public static Result<?> forbidden() {
        return ResultInfo.error(ResultEnum.FORBIDDEN.getCode(), ResultEnum.FORBIDDEN.getMsg());
    }

    public static Result<?> frequent_access_restriction() {
        return ResultInfo.error(ResultEnum.FREQUENT_ACCESS_RESTRICTION.getCode(), ResultEnum.FREQUENT_ACCESS_RESTRICTION.getMsg());
    }

    public static Result<?> success() {
        return Result.builder().code(ResultEnum.SUCCESS.getCode()).msg(ResultEnum.SUCCESS.getMsg()).flag(true).build();
    }

    public static <T> Result<T> success(T data) {
        return new Result().toBuilder().code(ResultEnum.SUCCESS.getCode()).msg(ResultEnum.SUCCESS.getMsg()).flag(true).data(data).build();
    }

    public static <T> Result<T> success(T data, Long count) {
        Result<T> result = new Result<T>(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg(), true, data, count);
        return result;
    }

    public static <T> Result<T> success(Integer code, T data, Long count) {
        Result<T> result = new Result<T>(code, ResultEnum.SUCCESS.getMsg(), true, data, count);
        return result;
    }

    public static Result<?> resource_already_invalid() {
        return ResultInfo.error(ResultEnum.RESOURCE_ALREADY_INVALID.getCode(), ResultEnum.RESOURCE_ALREADY_INVALID.getMsg());
    }

    public static Result<?> file_empty() {
        return ResultInfo.error(ResultEnum.FILE_EMPTY.getCode(), ResultEnum.FILE_EMPTY.getMsg());
    }

    public static Result<?> type_convert_error(String data) {
        return ResultInfo.error(ResultEnum.TYPE_CONVERT_ERROR.getCode(), ResultEnum.TYPE_CONVERT_ERROR.getMsg(), data);
    }

    public static Result<?> param_void() {
        return ResultInfo.error(ResultEnum.PARAM_VOID.getCode(), ResultEnum.PARAM_VOID.getMsg());
    }

    public static Result<?> param_check_not_pass() {
        return ResultInfo.error(ResultEnum.PARAM_CHECK_NOT_PASS.getCode(), ResultEnum.PARAM_CHECK_NOT_PASS.getMsg());
    }

    public static Result<String> param_check_not_pass(String data) {
        return ResultInfo.error(ResultEnum.PARAM_CHECK_NOT_PASS.getCode(), ResultEnum.PARAM_CHECK_NOT_PASS.getMsg(), data);
    }

    public static Result<?> param_value_invalid() {
        return ResultInfo.error(ResultEnum.PARAM_VALUE_INVALID.getCode(), ResultEnum.PARAM_VALUE_INVALID.getMsg());
    }

    public static Result<String> param_value_invalid(String data) {
        return ResultInfo.error(ResultEnum.PARAM_VALUE_INVALID.getCode(), ResultEnum.PARAM_VALUE_INVALID.getMsg(), data);
    }

    public static Result<?> param_decrypt_error() {
        return ResultInfo.error(ResultEnum.PARAM_DECRYPT_ERROR.getCode(), ResultEnum.PARAM_DECRYPT_ERROR.getMsg());
    }

    public static Result<?> error() {
        return ResultInfo.error(ResultEnum.ERROR.getCode(), ResultEnum.ERROR.getMsg());
    }

    public static <T> Result<T> error(T data) {
        return ResultInfo.error(ResultEnum.ERROR.getCode(), ResultEnum.ERROR.getMsg(), data);
    }

    public static Result<?> data_structure() {
        return ResultInfo.error(ResultEnum.DATA_STRUCTURE.getCode(), ResultEnum.DATA_STRUCTURE.getMsg());
    }

    public static Result<?> data_structure(int expected, int actual) {
        String data = "Incorrect result size: expected " + expected + ", actual " + actual;
        return ResultInfo.error(ResultEnum.DATA_STRUCTURE.getCode(), ResultEnum.DATA_STRUCTURE.getMsg(), data);
    }

    public static Result<?> db_error() {
        return ResultInfo.error(ResultEnum.DB_ERROR.getCode(), ResultEnum.DB_ERROR.getMsg());
    }

    public static Result<?> client_fallback() {
        return ResultInfo.error(ResultEnum.CLIENT_FALLBACK.getCode(), ResultEnum.CLIENT_FALLBACK.getMsg());
    }

    public static Result<?> client_fallback_error() {
        return ResultInfo.error(ResultEnum.CLIENT_FALLBACK_ERROR.getCode(), ResultEnum.CLIENT_FALLBACK_ERROR.getMsg());
    }

    public static Result<?> dev_defined(String msg) {
        return ResultInfo.error(ResultEnum.DEV_DEFINED.getCode(), msg);
    }
}

