/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils
extends MapUtil {
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);
    public static final JSONObject FINAL_EMPTY_JSON = new JSONObject();

    public static boolean isKeys(Map<String, Object> paramMap, String[] mustContainKeys, String ... canContainKeys) {
        for (String key : mustContainKeys) {
            if (paramMap.containsKey(key)) continue;
            return false;
        }
        if (StringUtils.isEmptys(canContainKeys)) {
            return true;
        }
        int keySize = mustContainKeys.length + canContainKeys.length;
        if (paramMap.size() > keySize) {
            return false;
        }
        int paramMapCanContainKeysLength = 0;
        for (String key : canContainKeys) {
            if (!paramMap.containsKey(key)) continue;
            ++paramMapCanContainKeysLength;
        }
        return paramMapCanContainKeysLength + mustContainKeys.length == paramMap.size();
    }

    public static boolean isKeysEqual(Map<String, Object> paramMap, String[] keys) {
        if (paramMap.size() != keys.length) {
            return false;
        }
        for (String key : keys) {
            if (paramMap.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainsOneOfKey(Map<String, Object> paramMap, String[] keys) {
        for (String key : keys) {
            if (!paramMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMapsKeys(Map<String, Object>[] paramMaps, String[] keys) {
        return MapUtils.isKeys(paramMaps[0], keys, new String[0]);
    }

    public static boolean isEmptys(Map<String, Object>[] paramMaps) {
        return null == paramMaps || paramMaps.length == 0 || paramMaps[0].isEmpty();
    }

    public static boolean isStringValueEmpty(Map<String, Object> paramMap) {
        if (paramMap.isEmpty()) {
            return true;
        }
        for (Object value : paramMap.values()) {
            if (null != value && !"".equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void trimStringValues(Map<String, Object> paramMap) {
        for (String key : paramMap.keySet()) {
            String value;
            String str = MapUtils.getString(paramMap, key);
            if (str.equals(value = str.trim())) continue;
            paramMap.replace(key, value);
        }
    }

    public static void remove(Map<String, Object> paramMap, String[] keys) {
        for (String key : keys) {
            paramMap.remove(key);
        }
    }

    public static void removeEmpty(Map<String, Object> paramMap) {
        Iterator<Map.Entry<String, Object>> iter = paramMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (!ObjectUtils.isNull((Object)value)) continue;
            iter.remove();
        }
    }

    public static void removeBlankStr(Map<String, Object> paramMap) {
        Iterator<Map.Entry<String, Object>> iter = paramMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (!StrUtil.isBlankIfStr((Object)value)) continue;
            iter.remove();
        }
    }

    public static void replaceKey(Map<String, Object> paramMap, String key, String replaceKey) {
        Object value = paramMap.get(key);
        paramMap.put(replaceKey, value);
        paramMap.remove(key);
    }

    public static List<String> keyList(Map<String, Object> paramMap) {
        ArrayList<String> list = new ArrayList<String>();
        paramMap.keySet().forEach(action -> list.add((String)action));
        return list;
    }

    public static JSONObject getJSONObject(Map<String, Object> paramMap, String ... keys) {
        JSONObject paramJson = new JSONObject(paramMap);
        if (!MapUtils.isContainsOneOfKey((Map<String, Object>)paramJson, keys)) {
            return null;
        }
        JSONObject resultJson = new JSONObject();
        for (String key : keys) {
            Object value = paramJson.get((Object)key);
            if (value == null) continue;
            resultJson.put(key, value);
        }
        return resultJson;
    }

    public static <T> T getObject(Map<?, ?> paramMap, Object key, Class<T> clazz) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            return Convert.toObject(answer, clazz);
        }
        return null;
    }

    public static Number getNumber(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getString(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map<?, ?> paramMap, Object key) {
        Object answer;
        if (paramMap != null && (answer = paramMap.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Integer getInteger(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return answer.intValue();
    }

    public static Long getLong(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return answer.longValue();
    }

    public static Double getDouble(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return answer.doubleValue();
    }

    public static BigDecimal getBigDecimal(Map<?, ?> paramMap, Object key) {
        Number answer = MapUtils.getNumber(paramMap, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return new BigDecimal((Double)answer);
        }
        return new BigDecimal(answer.doubleValue());
    }

    public static JSONObject getJSONObject(Map<?, ?> paramMap, String key) {
        Object value = paramMap.get(key);
        return Convert.toJSONObject(value);
    }

    public static JSONArray getJSONArray(Map<?, ?> paramMap, String key) {
        Object value = paramMap.get(key);
        return Convert.toJSONArray(value);
    }

    public static JSONObject toCamelCase(Object param) {
        return MapUtils.toPropertyNamingStrategy(param, PropertyNamingStrategy.CamelCase);
    }

    public static JSONObject toUnderlineCase(Object param) {
        return MapUtils.toPropertyNamingStrategy(param, PropertyNamingStrategy.SnakeCase);
    }

    public static JSONObject toSnakeCase(Object param) {
        return MapUtils.toPropertyNamingStrategy(param, PropertyNamingStrategy.SnakeCase);
    }

    public static JSONObject toPropertyNamingStrategy(Object param, PropertyNamingStrategy propertyNamingStrategy) {
        if (param instanceof Map) {
            JSONObject jsonObject = Convert.toJSONObject(param);
            if (MapUtils.isEmpty((Map)jsonObject)) {
                return jsonObject;
            }
            JSONObject paramJson = new JSONObject(true);
            jsonObject.forEach((key, value) -> paramJson.put(propertyNamingStrategy.translate(key), value));
            return paramJson;
        }
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setPropertyNamingStrategy(propertyNamingStrategy);
        JSONObject paramJson = (JSONObject)JSONObject.toJSON((Object)param, (SerializeConfig)serializeConfig);
        return paramJson;
    }

    public static <T> Map<String, List<T>> listPOJOExtractKeyToList(List<T> objectList, String key) {
        LinkedHashMap<String, List<T>> map = new LinkedHashMap<String, List<T>>();
        if (ListUtils.isEmpty(objectList)) {
            return map;
        }
        for (T item : objectList) {
            Object valueKey = null;
            try {
                valueKey = MapUtils.getValue(item, key);
            }
            catch (Exception e) {
                log.error("\u672a\u627e\u5230\u65b9\u6cd5\u503c", (Throwable)e);
            }
            ArrayList<T> list = (ArrayList<T>)map.get(valueKey == null ? null : valueKey.toString());
            if (list == null) {
                list = new ArrayList<T>();
                map.put(valueKey == null ? null : valueKey.toString(), list);
            }
            list.add(item);
        }
        return map;
    }

    public static <T> Map<String, T> listPOJOExtractKeyToPOJO(List<T> objectList, String key) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        if (objectList == null || objectList.isEmpty()) {
            return map;
        }
        for (T item : objectList) {
            Object mapKey = null;
            try {
                mapKey = MapUtils.getValue(item, key);
            }
            catch (Exception e) {
                log.error("\u672a\u627e\u5230\u65b9\u6cd5\u503c", (Throwable)e);
            }
            map.put(mapKey == null ? null : mapKey.toString(), item);
        }
        return map;
    }

    private static Object getValue(Object obj, String name) {
        PropertyDescriptor[] descriptors;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(obj.getClass());
        }
        catch (IntrospectionException e) {
            log.info("\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            return null;
        }
        for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
            Method readMethod = descriptor.getReadMethod();
            if (!name.equals(descriptor.getName())) continue;
            try {
                Object value = readMethod.invoke(obj, new Object[0]);
                return value;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.info("\u83b7\u53d6\u503c\u53d1\u751f\u9519\u8bef", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

