/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.annotation.api.version;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="yue.api-version")
public class ApiVersionProperties {
    private boolean enabled = true;
    private double minimumVersion;
    private String versionPlaceholder = "{version}";

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getMinimumVersion() {
        return this.minimumVersion;
    }

    public String getVersionPlaceholder() {
        return this.versionPlaceholder;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMinimumVersion(double minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public void setVersionPlaceholder(String versionPlaceholder) {
        this.versionPlaceholder = versionPlaceholder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiVersionProperties)) {
            return false;
        }
        ApiVersionProperties other = (ApiVersionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getMinimumVersion(), other.getMinimumVersion()) != 0) {
            return false;
        }
        String this$versionPlaceholder = this.getVersionPlaceholder();
        String other$versionPlaceholder = other.getVersionPlaceholder();
        return !(this$versionPlaceholder == null ? other$versionPlaceholder != null : !this$versionPlaceholder.equals(other$versionPlaceholder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiVersionProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $minimumVersion = Double.doubleToLongBits(this.getMinimumVersion());
        result = result * 59 + (int)($minimumVersion >>> 32 ^ $minimumVersion);
        String $versionPlaceholder = this.getVersionPlaceholder();
        result = result * 59 + ($versionPlaceholder == null ? 43 : $versionPlaceholder.hashCode());
        return result;
    }

    public String toString() {
        return "ApiVersionProperties(enabled=" + this.isEnabled() + ", minimumVersion=" + this.getMinimumVersion() + ", versionPlaceholder=" + this.getVersionPlaceholder() + ")";
    }
}

