/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.config.datetime;

import ai.yue.library.base.util.DateUtils;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class DateTimeFormatConfig {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return builder -> builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateUtils.DATE_TIME_FORMATTER)).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateUtils.DATE_FORMATTER)).serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateUtils.TIME_FORMATTER)).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateUtils.DATE_TIME_FORMATTER)).deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateUtils.DATE_FORMATTER)).deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateUtils.TIME_FORMATTER));
    }

    @Bean
    public Converter<String, LocalDateTime> localDateTimeConvert() {
        return new Converter<String, LocalDateTime>(){

            public LocalDateTime convert(String source) {
                return LocalDateTime.parse(source, DateUtils.DATE_TIME_FORMATTER);
            }
        };
    }

    @Bean
    public Converter<String, LocalDate> localDateConvert() {
        return new Converter<String, LocalDate>(){

            public LocalDate convert(String source) {
                return LocalDate.parse(source, DateUtils.DATE_FORMATTER);
            }
        };
    }

    @Bean
    public Converter<String, LocalTime> localTimeConvert() {
        return new Converter<String, LocalTime>(){

            public LocalTime convert(String source) {
                return LocalTime.parse(source, DateUtils.TIME_FORMATTER);
            }
        };
    }
}

