/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.exception;

import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;

public class ResultException
extends RuntimeException {
    private static final long serialVersionUID = -4332073495864145387L;
    private int businessId;
    private Result<?> result;

    public ResultException(String msg) {
        super(msg);
        this.result = R.errorPrompt(msg);
    }

    public ResultException(Result<?> result) {
        super(result.getMsg());
        this.result = result;
    }

    public ResultException(int businessId, String msg) {
        super(msg);
        this.businessId = businessId;
        this.result = R.errorPrompt(msg);
    }

    public ResultException(int businessId, Result<?> result) {
        super(result.getMsg());
        this.businessId = businessId;
        this.result = result;
    }

    public int getBusinessId() {
        return this.businessId;
    }

    public Result<?> getResult() {
        return this.result;
    }

    public void setBusinessId(int businessId) {
        this.businessId = businessId;
    }

    public void setResult(Result<?> result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "ResultException(businessId=" + this.getBusinessId() + ", result=" + this.getResult() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultException)) {
            return false;
        }
        ResultException other = (ResultException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBusinessId() != other.getBusinessId()) {
            return false;
        }
        Result<?> this$result = this.getResult();
        Result<?> other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBusinessId();
        Result<?> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }
}

