/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import com.alibaba.fastjson.JSONObject;
import org.springframework.lang.Nullable;

public class ExceptionUtils {
    private static synchronized <T> T getPrintException(Throwable e, @Nullable Integer line, ExceptionConvertEnum exceptionConvertEnum) {
        Object msg = null;
        if (exceptionConvertEnum == ExceptionConvertEnum.JSONObject) {
            msg = new JSONObject(true);
            if (e == null) {
                msg.put("0", (Object)"The stack trace is null");
                return (T)msg;
            }
            msg.put("0", (Object)e.toString());
        } else if (exceptionConvertEnum == ExceptionConvertEnum.StringBuffer) {
            msg = new StringBuffer();
            if (e == null) {
                ((StringBuffer)msg).append("The stack trace is null");
                return (T)msg;
            }
            ((StringBuffer)msg).append(e + "\n");
        }
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int maxLine = stackTraceElementArray.length;
        line = line == null ? Integer.valueOf(maxLine) : Integer.valueOf(line > maxLine ? maxLine : line);
        for (int i = 0; i < line; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String fileName = stackTraceElement.getFileName();
            String className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            int lineNumber = stackTraceElement.getLineNumber();
            if (exceptionConvertEnum == ExceptionConvertEnum.JSONObject) {
                msg.put("" + (i + 1), (Object)("\u3000\u3000at " + className + "." + methodName + "(" + fileName + ":" + lineNumber + ")"));
            }
            if (exceptionConvertEnum != ExceptionConvertEnum.StringBuffer) continue;
            ((StringBuffer)msg).append("\tat " + className + "." + methodName + "(" + fileName + ":" + lineNumber + ")\n");
        }
        return (T)msg;
    }

    public static synchronized String getPrintExceptionToStr(Throwable e) {
        return ExceptionUtils.getPrintExceptionToStr(e, 4);
    }

    public static synchronized String getPrintExceptionToStr(Throwable e, @Nullable Integer line) {
        StringBuffer printException = (StringBuffer)ExceptionUtils.getPrintException(e, line, ExceptionConvertEnum.StringBuffer);
        return printException.toString();
    }

    public static synchronized JSONObject getPrintExceptionToJson(Throwable e) {
        return ExceptionUtils.getPrintExceptionToJson(e, 4);
    }

    public static synchronized JSONObject getPrintExceptionToJson(Throwable e, @Nullable Integer line) {
        return (JSONObject)ExceptionUtils.getPrintException(e, line, ExceptionConvertEnum.JSONObject);
    }

    public static synchronized void printException(Throwable e) {
        ExceptionUtils.printException(e, 4);
    }

    public static synchronized void printException(Throwable e, @Nullable Integer line) {
        System.err.print(ExceptionUtils.getPrintExceptionToStr(e, line));
    }

    private static enum ExceptionConvertEnum {
        JSONObject,
        StringBuffer;

    }
}

