/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;

@Component
public class I18nUtils {
    private static final Logger log = LoggerFactory.getLogger(I18nUtils.class);
    private static MessageSource messageSource;
    private static ResourceBundleMessageSource messageSourceYue;

    public I18nUtils(MessageSource messageSource) {
        I18nUtils.messageSource = messageSource;
        messageSourceYue = new ResourceBundleMessageSource();
        messageSourceYue.setBasenames(new String[]{"YueMessages", "messages"});
        messageSourceYue.setDefaultEncoding(StandardCharsets.UTF_8.name());
    }

    public static String get(String code, Object ... args) {
        try {
            return messageSource.getMessage(code, args, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return code;
        }
    }

    public static String getYue(String msgKey) {
        try {
            return messageSourceYue.getMessage(msgKey, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return msgKey;
        }
    }
}

