/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.util;

import ai.yue.library.base.constant.MaxOrMinEnum;
import ai.yue.library.base.constant.SortEnum;
import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListUtils
extends ListUtil {
    public static boolean isEmpty(List<?> list) {
        return null == list || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return !ListUtils.isEmpty(list);
    }

    public static <T> T get(List<?> list, Class<T> clazz) {
        for (Object value : list) {
            if (value == null || value.getClass() != clazz) continue;
            return (T)value;
        }
        return null;
    }

    public static List<List<JSONObject>> grouping(List<JSONObject> list, String key) {
        ArrayList<List<JSONObject>> result = new ArrayList<List<JSONObject>>();
        ListUtils.toListAndDistinct(list, key).forEach(str -> {
            ArrayList jsonList = new ArrayList();
            list.forEach(json -> {
                if (str.equals(json.getString(key))) {
                    jsonList.add(json);
                }
            });
            result.add(jsonList);
        });
        return result;
    }

    public static List<String> keepSameValue(List<String> list, List<String> list2) {
        ArrayList<String> result = new ArrayList<String>();
        list.forEach(str -> list2.forEach(str2 -> {
            if (str.equals(str2)) {
                result.add((String)str);
            }
        }));
        return result;
    }

    public static JSONArray merge(JSONArray array, JSONObject json, String key) {
        array.forEach(arrayObj -> {
            JSONObject temp = Convert.toJSONObject(arrayObj);
            String value = temp.getString(key);
            temp.putAll((Map)json.getJSONObject(value));
        });
        return array;
    }

    public static void merge(List<JSONObject> list1, List<JSONObject> list2, String key1, String key2) {
        list1.forEach(json1 -> {
            Object value1 = json1.get((Object)key1);
            for (JSONObject json2 : list2) {
                Object value2 = json2.get((Object)key2);
                if (!ObjectUtils.equals(value1, value2)) continue;
                json2.remove((Object)key2);
                json1.putAll((Map)json2);
                break;
            }
        });
    }

    public static List<JSONObject> sort(List<JSONObject> list, String sortKey, SortEnum sortEnum) {
        Collections.sort(list, (json1, json2) -> {
            Object json1value = json1.get((Object)sortKey);
            Object json2value = json2.get((Object)sortKey);
            if (sortEnum == SortEnum.ASC) {
                return CompareUtil.compare((Object)json1value, (Object)json2value, (boolean)false);
            }
            return CompareUtil.compare((Object)json2value, (Object)json1value, (boolean)false);
        });
        return list;
    }

    public static <T> List<T> sortT(List<T> list, String sortField, SortEnum sortEnum) {
        Collections.sort(list, (o1, o2) -> {
            JSONObject json1 = Convert.toJSONObject(o1);
            JSONObject json2 = Convert.toJSONObject(o2);
            Object json1value = json1.get((Object)sortField);
            Object json2value = json2.get((Object)sortField);
            if (sortEnum == SortEnum.ASC) {
                return CompareUtil.compare((Object)json1value, (Object)json2value, (boolean)false);
            }
            return CompareUtil.compare((Object)json2value, (Object)json1value, (boolean)false);
        });
        return list;
    }

    public static <T> List<T> reverse(List<T> list, Class<T> clazz) {
        return ListUtils.toList(ArrayUtil.reverse((Object[])ArrayUtil.toArray(list, clazz)));
    }

    public static <T> List<T> distinct(List<T> list) {
        HashSet<T> h = new HashSet<T>(list);
        list.clear();
        list.addAll(h);
        return list;
    }

    public static List<JSONObject> distinct(List<JSONObject> list, String distinctKey) {
        for (int i = 0; i < list.size(); ++i) {
            JSONObject jsoni = list.get(i);
            for (int j = list.size() - 1; j > i; --j) {
                JSONObject jsonj = list.get(j);
                if (!jsoni.get((Object)distinctKey).equals(jsonj.get((Object)distinctKey))) continue;
                list.remove(j);
            }
        }
        return list;
    }

    public static List<JSONObject> distinctCount(List<JSONObject> list, String distinctKey, SortEnum sortEnum) {
        for (int i = 0; i < list.size(); ++i) {
            int frequency = 1;
            JSONObject jsoni = list.get(i);
            for (int j = list.size() - 1; j > i; --j) {
                JSONObject jsonj = list.get(j);
                if (!jsoni.get((Object)distinctKey).equals(jsonj.get((Object)distinctKey))) continue;
                list.remove(j);
                ++frequency;
            }
            jsoni.put("frequency", (Object)frequency);
        }
        return ListUtils.sort(list, "frequency", sortEnum);
    }

    public static List<JSONObject> distinctCountSortSelectKeep(List<JSONObject> list, String distinctKey, SortEnum sortEnum, String keepKey, MaxOrMinEnum maxOrMinEnum) {
        for (int i = 0; i < list.size(); ++i) {
            int frequency = 1;
            JSONObject jsoni = list.get(i);
            for (int j = list.size() - 1; j > i; --j) {
                JSONObject jsonj = list.get(j);
                if (!jsoni.get((Object)distinctKey).equals(jsonj.get((Object)distinctKey))) continue;
                if (CompareUtil.compare((Object)jsoni.get((Object)keepKey), (Object)jsonj.get((Object)keepKey), (boolean)false) > 0) {
                    if (maxOrMinEnum == MaxOrMinEnum.MIN) {
                        jsoni.replace((Object)keepKey, jsonj.get((Object)keepKey));
                    }
                    list.remove(j);
                    ++frequency;
                    continue;
                }
                if (maxOrMinEnum == MaxOrMinEnum.MAX) {
                    jsoni.replace((Object)keepKey, jsonj.get((Object)keepKey));
                }
                list.remove(j);
                ++frequency;
            }
            jsoni.put("frequency", (Object)frequency);
        }
        return ListUtils.sort(list, "frequency", sortEnum);
    }

    public static <T> ArrayList<T> toList(T[] array) {
        ArrayList<T> toList = new ArrayList<T>(Arrays.asList(array));
        return toList;
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> clazz) {
        return jsonArray.toJavaList(clazz);
    }

    public static <T> List<T> toList(List<JSONObject> list, Class<T> clazz) {
        ArrayList<T> toList = new ArrayList<T>();
        for (JSONObject json : list) {
            toList.add(Convert.toJavaBean(json, clazz));
        }
        return toList;
    }

    public static List<String> toList(List<JSONObject> list, String keepKey) {
        ArrayList<String> toList = new ArrayList<String>();
        for (JSONObject json : list) {
            String value = json.getString(keepKey);
            toList.add(value);
        }
        return toList;
    }

    public static <T> List<T> toList(List<JSONObject> list, String keepKey, Class<T> clazz) {
        ArrayList<T> toList = new ArrayList<T>();
        for (JSONObject json : list) {
            toList.add(Convert.toObject(json.get((Object)keepKey), clazz));
        }
        return toList;
    }

    public static List<String> toListAndDistinct(List<JSONObject> list, String keepKey) {
        ArrayList<String> toList = new ArrayList<String>();
        for (JSONObject json : list) {
            String value = json.getString(keepKey);
            toList.add(value);
        }
        return ListUtils.distinct(toList);
    }

    public static <T> List<T> toListAndDistinct(List<JSONObject> list, String keepKey, Class<T> clazz) {
        return ListUtils.distinct(ListUtils.toList(list, keepKey, clazz));
    }

    public static List<JSONObject> toJsonList(List<Map<String, Object>> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (int i = 0; i < list.size(); ++i) {
            jsonList.add(new JSONObject(list.get(i)));
        }
        return jsonList;
    }

    public static List<JSONObject> toJsonList(JSONArray jsonArray) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonList.add(jsonArray.getJSONObject(i));
        }
        return jsonList;
    }

    public static <T> List<JSONObject> toJsonListT(List<T> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (T obj : list) {
            jsonList.add(Convert.toJSONObject(obj));
        }
        return jsonList;
    }

    public static JSONObject[] toJsons(JSONArray jsonArray) {
        int size = jsonArray.size();
        JSONObject[] jsons = new JSONObject[size];
        for (int i = 0; i < size; ++i) {
            jsons[i] = jsonArray.getJSONObject(i);
        }
        return jsons;
    }

    public static JSONObject[] toJsons(List<JSONObject> list) {
        JSONObject[] jsons = new JSONObject[list.size()];
        int index = 0;
        Iterator<JSONObject> iterator = list.iterator();
        while (iterator.hasNext()) {
            JSONObject json;
            jsons[index] = json = iterator.next();
            ++index;
        }
        return jsons;
    }

    public static <T> JSONObject[] toJsonsT(List<T> list) {
        JSONObject[] jsons = new JSONObject[list.size()];
        int index = 0;
        for (T obj : list) {
            jsons[index] = Convert.toJSONObject(obj);
            ++index;
        }
        return jsons;
    }

    public static <T> JSONObject[] toJsonsTAndRemoveEmpty(List<T> list) {
        JSONObject[] jsons = new JSONObject[list.size()];
        int index = 0;
        for (T obj : list) {
            JSONObject json = Convert.toJSONObject(obj);
            MapUtils.removeEmpty((Map<String, Object>)json);
            jsons[index] = json;
            ++index;
        }
        return jsons;
    }

    public static JSONObject[] toJsons(String jsonString) {
        return ListUtils.toJsons(JSONArray.parseArray((String)jsonString));
    }

    public static JSONObject[] toJsons(String text, String regex, String key) {
        String[] texts = text.split(regex);
        JSONObject[] jsons = new JSONObject[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            JSONObject paramJson = new JSONObject();
            paramJson.put(key, (Object)texts[i]);
            jsons[i] = paramJson;
        }
        return jsons;
    }

    public static List<JSONObject> toSnakeCaseJsonList(List<JSONObject> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (JSONObject json : list) {
            jsonList.add(Convert.toSnakeCase(json));
        }
        return jsonList;
    }

    public static <T> List<JSONObject> toSnakeCaseJsonListT(List<T> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (T obj : list) {
            jsonList.add(Convert.toSnakeCase(obj));
        }
        return jsonList;
    }

    public static List<JSONObject> toUnderlineCaseJsonList(List<JSONObject> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (JSONObject json : list) {
            jsonList.add(Convert.toUnderlineCase(json));
        }
        return jsonList;
    }

    public static <T> List<JSONObject> toUnderlineCaseJsonListT(List<T> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (T obj : list) {
            jsonList.add(Convert.toUnderlineCase(obj));
        }
        return jsonList;
    }

    public static List<JSONObject> toCamelCaseJsonList(List<JSONObject> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (JSONObject json : list) {
            jsonList.add(Convert.toCamelCase(json));
        }
        return jsonList;
    }

    public static <T> List<JSONObject> toCamelCaseJsonListT(List<T> list) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>(list.size());
        for (T obj : list) {
            jsonList.add(Convert.toCamelCase(obj));
        }
        return jsonList;
    }
}

