/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.validation.annotation;

import ai.yue.library.base.util.DateUtils;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.base.validation.annotation.Birthday;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class BirthdayValidator
implements ConstraintValidator<Birthday, Object> {
    private boolean notNull;

    public void initialize(Birthday constraintAnnotation) {
        this.notNull = constraintAnnotation.notNull();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        String validValue = null;
        if (value instanceof String) {
            validValue = (String)value;
        } else if (value instanceof Date) {
            validValue = DateUtil.formatDate((Date)((Date)value));
        } else if (value instanceof TemporalAccessor) {
            validValue = DateUtils.toDateFormatter((TemporalAccessor)value);
        }
        if (StringUtils.isNotBlank((CharSequence)validValue)) {
            return Validator.isBirthday((CharSequence)validValue);
        }
        return !this.notNull;
    }
}

