/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.base.view;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.SpringUtils;
import ai.yue.library.base.webenv.WebEnv;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.http.ResponseEntity;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -3830508963654505583L;
    @JSONField(ordinal=1)
    private Integer code;
    @JSONField(ordinal=2)
    private String msg;
    @JSONField(ordinal=3)
    private boolean flag;
    @JSONField(ordinal=4)
    private Long count;
    @JSONField(ordinal=5)
    private T data;

    public void successValidate() {
        if (!this.flag) {
            throw new ResultException(this);
        }
    }

    public <D> D getData(Class<D> clazz) {
        return Convert.convert(this.data, clazz);
    }

    public <D> D dataToObject(Class<D> clazz) {
        return this.getData(clazz);
    }

    public <D> D dataToJavaBean(Class<D> clazz) {
        return Convert.toJavaBean(this.data, clazz);
    }

    public JSONObject dataToJSONObject() {
        return Convert.toJSONObject(this.data);
    }

    public JSONArray dataToJSONArray() {
        return Convert.toJSONArray(this.data);
    }

    public <D> List<D> dataToList(Class<D> clazz) {
        return Convert.toList(clazz, this.data);
    }

    public List<JSONObject> dataToJsonList() {
        List dataTemp;
        if (this.data instanceof List && ListUtils.isNotEmpty(dataTemp = (List)this.data) && dataTemp.get(0) instanceof JSONObject) {
            return (List)this.data;
        }
        return ListUtils.toJsonList(this.dataToJSONArray());
    }

    public Boolean dataToBoolean() {
        if (this.data == null) {
            return null;
        }
        return TypeUtils.castToBoolean(this.data);
    }

    public Integer dataToInteger() {
        return TypeUtils.castToInt(this.data);
    }

    public Long dataToLong() {
        return TypeUtils.castToLong(this.data);
    }

    public Double dataToDouble() {
        return TypeUtils.castToDouble(this.data);
    }

    public BigDecimal dataToBigDecimal() {
        return TypeUtils.castToBigDecimal(this.data);
    }

    public BigInteger dataToBigInteger() {
        return TypeUtils.castToBigInteger(this.data);
    }

    public String dataToString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    public String dataToJSONString() {
        if (this.data == null) {
            return null;
        }
        return JSONObject.toJSONString(this.data);
    }

    public java.util.Date dataToDate() {
        return TypeUtils.castToDate(this.data);
    }

    public Date dataToSqlDate() {
        return TypeUtils.castToSqlDate(this.data);
    }

    public Timestamp dataToTimestamp() {
        return TypeUtils.castToTimestamp(this.data);
    }

    public ResponseEntity<Result<?>> castToResponseEntity() {
        return ResponseEntity.status((int)this.getCode()).body((Object)this);
    }

    public void response() {
        WebEnv webEnv = SpringUtils.getBean(WebEnv.class);
        webEnv.resultResponse(this);
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public ResultBuilder<T> toBuilder() {
        return new ResultBuilder().code(this.code).msg(this.msg).flag(this.flag).count(this.count).data(this.data);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public Long getCount() {
        return this.count;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFlag() != other.isFlag()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlag() ? 79 : 97);
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", flag=" + this.isFlag() + ", count=" + this.getCount() + ", data=" + this.getData() + ")";
    }

    public Result() {
    }

    public Result(Integer code, String msg, boolean flag, Long count, T data) {
        this.code = code;
        this.msg = msg;
        this.flag = flag;
        this.count = count;
        this.data = data;
    }

    public static class ResultBuilder<T> {
        private Integer code;
        private String msg;
        private boolean flag;
        private Long count;
        private T data;

        ResultBuilder() {
        }

        public ResultBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public ResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ResultBuilder<T> flag(boolean flag) {
            this.flag = flag;
            return this;
        }

        public ResultBuilder<T> count(Long count) {
            this.count = count;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.code, this.msg, this.flag, this.count, this.data);
        }

        public String toString() {
            return "Result.ResultBuilder(code=" + this.code + ", msg=" + this.msg + ", flag=" + this.flag + ", count=" + this.count + ", data=" + this.data + ")";
        }
    }
}

