/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.data.es.config.sql;

import ai.yue.library.data.es.config.sql.EsSqlProperties;
import ai.yue.library.data.jdbc.client.Db;
import cn.hutool.core.util.StrUtil;
import com.amazon.opendistroforelasticsearch.jdbc.ElasticsearchDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EsSqlProperties.class})
@ConditionalOnProperty(prefix="yue.es.sql", name={"enabled"}, havingValue="true")
public class EsSqlConfig {
    @Autowired
    EsSqlProperties esSqlProperties;

    @Bean
    public Db esDb() throws SQLException {
        String url = "jdbc:elasticsearch://" + this.esSqlProperties.getUrl();
        ElasticsearchDataSource ds = new ElasticsearchDataSource();
        ds.setUrl(url);
        Properties properties = new Properties();
        properties.setProperty("trustSelfSigned", String.valueOf(this.esSqlProperties.isTrustSelfSigned()));
        properties.setProperty("hostnameVerification", String.valueOf(this.esSqlProperties.isHostnameVerification()));
        String username = this.esSqlProperties.getUsername();
        String password = this.esSqlProperties.getPassword();
        if (StrUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{username, password})) {
            properties.setProperty("user", username);
            properties.setProperty("password", password);
        }
        ds.setProperties(properties);
        return new Db((DataSource)ds);
    }
}

