/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.pay.client;

import ai.yue.library.pay.ipo.PayOrderIPO;
import ai.yue.library.pay.ipo.QueryOrderIPO;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public class Pay {
    private Map<Integer, PayService> payServiceMap;

    private PayService<?> getPayService(Integer listId) {
        PayService payService = this.payServiceMap.get(listId);
        if (payService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94listId=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", listId));
        }
        return payService;
    }

    public String toPay(PayOrderIPO payOrderIPO) {
        PayService<?> payService = this.getPayService(payOrderIPO.getListId());
        Map orderInfo = payService.orderInfo((PayOrder)payOrderIPO);
        return payService.buildRequest(orderInfo, MethodType.POST);
    }

    public Map<String, Object> getOrderInfo(PayOrderIPO payOrderIPO) {
        return this.getPayService(payOrderIPO.getListId()).orderInfo((PayOrder)payOrderIPO);
    }

    public Map<String, Object> microPay(PayOrderIPO payOrderIPO) {
        PayService<?> payService = this.getPayService(payOrderIPO.getListId());
        return payService.microPay((PayOrder)payOrderIPO);
    }

    public byte[] toQrPay(PayOrderIPO payOrderIPO) throws IOException {
        PayService<?> payService = this.getPayService(payOrderIPO.getListId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)payService.genQrPay((PayOrder)payOrderIPO), "JPEG", baos);
        return baos.toByteArray();
    }

    public String getQrPay(PayOrderIPO payOrderIPO) {
        return this.getPayService(payOrderIPO.getListId()).getQrPay((PayOrder)payOrderIPO);
    }

    public String payBack(Integer listId, Map<String, String[]> parameterMap, InputStream is) throws IOException {
        return this.getPayService(listId).payBack(parameterMap, is).toMessage();
    }

    public Map<String, Object> query(QueryOrderIPO queryOrderIPO) {
        return this.getPayService(queryOrderIPO.getListId()).query(queryOrderIPO.getTradeNo(), queryOrderIPO.getOutTradeNo());
    }

    public Map<String, Object> close(QueryOrderIPO queryOrderIPO) {
        return this.getPayService(queryOrderIPO.getListId()).close(queryOrderIPO.getTradeNo(), queryOrderIPO.getOutTradeNo());
    }

    public Map<String, Object> refund(Integer listId, RefundOrder order) {
        return this.getPayService(listId).refund(order);
    }

    public Map<String, Object> refundquery(Integer listId, RefundOrder refundOrder) {
        return this.getPayService(listId).refundquery(refundOrder);
    }

    public Object downloadbill(QueryOrderIPO queryOrderIPO) {
        return this.getPayService(queryOrderIPO.getListId()).downloadbill(queryOrderIPO.getBillDate(), queryOrderIPO.getBillType());
    }

    public Map<String, Object> secondaryInterface(QueryOrderIPO queryOrderIPO, TransactionType transactionType) {
        return this.getPayService(queryOrderIPO.getListId()).secondaryInterface(queryOrderIPO.getTradeNoOrBillDate(), queryOrderIPO.getOutTradeNoBillType(), transactionType);
    }

    public Map<String, Object> transfer(Integer listId, TransferOrder transferOrder) {
        return this.getPayService(listId).transfer(transferOrder);
    }

    public Map<String, Object> transferQuery(Integer listId, String outNo, String tradeNo) {
        return this.getPayService(listId).transferQuery(outNo, tradeNo);
    }

    public Pay(Map<Integer, PayService> payServiceMap) {
        this.payServiceMap = payServiceMap;
    }
}

