/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.pay.config;

import ai.yue.library.base.util.ListUtils;
import ai.yue.library.base.util.MapUtils;
import ai.yue.library.base.util.ObjectUtils;
import ai.yue.library.pay.client.Pay;
import ai.yue.library.pay.config.properties.AliPayProperties;
import ai.yue.library.pay.config.properties.WxPayProperties;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import com.egzosn.pay.ali.api.AliPayConfigStorage;
import com.egzosn.pay.ali.api.AliPayService;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.wx.api.WxPayConfigStorage;
import com.egzosn.pay.wx.api.WxPayService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={AliPayProperties.class, WxPayProperties.class})
public class PayAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(PayAutoConfig.class);
    @Autowired
    WxPayProperties wxPayProperties;
    @Autowired
    AliPayProperties aliPayProperties;
    Map<Integer, PayService> payServiceMap = MapUtils.newHashMap();

    @Bean
    @Primary
    public Pay pay() {
        if (this.wxPayProperties.isEnabled()) {
            if (!ClassLoaderUtil.isPresent((String)"com.egzosn.pay.wx.api.WxPayService")) {
                log.error("\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u672a\u5f15\u5165\u4f9d\u8d56\u6a21\u5757\uff1apay-java-wx");
            }
            this.wxPay();
        }
        if (this.aliPayProperties.isEnabled()) {
            if (!ClassLoaderUtil.isPresent((String)"com.egzosn.pay.ali.api.AliPayService")) {
                log.error("\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u672a\u5f15\u5165\u4f9d\u8d56\u6a21\u5757\uff1apay-java-ali");
            }
            this.aliPay();
        }
        return new Pay(this.payServiceMap);
    }

    private void wxPay() {
        List<WxPayProperties.WxPayConfig> configList = this.wxPayProperties.getConfigList();
        if (ListUtils.isEmpty(configList)) {
            throw new RuntimeException("\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u65e0\u6548\u7684\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e...");
        }
        configList.forEach(config -> {
            WxPayConfigStorage wxPayConfigStorage = new WxPayConfigStorage();
            wxPayConfigStorage.setMchId(config.getMchId());
            wxPayConfigStorage.setAppid(config.getAppId());
            wxPayConfigStorage.setKeyPublic(config.getKeyPublic());
            wxPayConfigStorage.setSecretKey(config.getSecretKey());
            wxPayConfigStorage.setNotifyUrl(config.getNotifyUrl());
            wxPayConfigStorage.setSignType(config.getSignType().name());
            wxPayConfigStorage.setInputCharset("utf-8");
            HttpConfigStorage httpConfigStorage = new HttpConfigStorage();
            httpConfigStorage.setMaxTotal(20);
            httpConfigStorage.setDefaultMaxPerRoute(10);
            WxPayService wxPayService = new WxPayService(wxPayConfigStorage, httpConfigStorage);
            Integer listId = config.getListId();
            if (ObjectUtils.isNotNull((Object)this.payServiceMap.get(listId))) {
                throw new RuntimeException(StrUtil.format((CharSequence)"\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u51fa\u73b0\u975e\u5168\u5c40\u552f\u4e00 listId\uff1a{}", (Object[])new Object[]{listId}));
            }
            this.payServiceMap.put(listId, (PayService)wxPayService);
        });
    }

    private void aliPay() {
        List<AliPayProperties.AliPayConfig> configList = this.aliPayProperties.getConfigList();
        if (ListUtils.isEmpty(configList)) {
            throw new RuntimeException("\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u65e0\u6548\u7684\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e...");
        }
        configList.forEach(config -> {
            AliPayConfigStorage aliPayConfigStorage = new AliPayConfigStorage();
            aliPayConfigStorage.setPid(config.getPid());
            aliPayConfigStorage.setAppid(config.getAppId());
            aliPayConfigStorage.setKeyPublic(config.getKeyPublic());
            aliPayConfigStorage.setKeyPrivate(config.getKeyPrivate());
            aliPayConfigStorage.setNotifyUrl(config.getNotifyUrl());
            aliPayConfigStorage.setSignType(config.getSignType().name());
            aliPayConfigStorage.setSeller(config.getSeller());
            aliPayConfigStorage.setInputCharset(config.getInputCharset());
            aliPayConfigStorage.setTest(config.getTest().booleanValue());
            HttpConfigStorage httpConfigStorage = new HttpConfigStorage();
            httpConfigStorage.setMaxTotal(20);
            httpConfigStorage.setDefaultMaxPerRoute(10);
            AliPayService aliPayService = new AliPayService(aliPayConfigStorage, httpConfigStorage);
            Integer listId = config.getListId();
            if (ObjectUtils.isNotNull((Object)this.payServiceMap.get(listId))) {
                throw new RuntimeException(StrUtil.format((CharSequence)"\u3010\u652f\u4ed8\u914d\u7f6e\u3011\u51fa\u73b0\u975e\u5168\u5c40\u552f\u4e00 listId\uff1a{}", (Object[])new Object[]{listId}));
            }
            this.payServiceMap.put(listId, (PayService)aliPayService);
        });
    }
}

