/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config;

import ai.yue.library.base.constant.FieldNamingStrategyEnum;
import ai.yue.library.base.util.ClassUtils;
import ai.yue.library.base.util.ListUtils;
import ai.yue.library.web.config.argument.resolver.ArrayArgumentResolver;
import ai.yue.library.web.config.argument.resolver.CustomRequestParamMethodArgumentResolver;
import ai.yue.library.web.config.argument.resolver.JavaBeanArgumentResolver;
import ai.yue.library.web.config.properties.FastJsonHttpMessageConverterProperties;
import ai.yue.library.web.config.properties.JacksonHttpMessageConverterProperties;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    @Autowired
    FastJsonHttpMessageConverterProperties fastJsonProperties;
    @Autowired
    JacksonHttpMessageConverterProperties jacksonProperties;

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        if (this.fastJsonProperties.isEnabled()) {
            this.fastJsonHttpMessageConverterConfig(converters);
        } else if (this.jacksonProperties.isEnabled()) {
            MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)ListUtils.get(converters, MappingJackson2HttpMessageConverter.class);
            this.mappingJackson2HttpMessageConverterConfig(mappingJackson2HttpMessageConverter);
        }
    }

    private void fastJsonHttpMessageConverterConfig(List<HttpMessageConverter<?>> converters) {
        FieldNamingStrategyEnum fieldNamingStrategy;
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        converter.setSupportedMediaTypes((List)CollUtil.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")}));
        FastJsonConfig config = new FastJsonConfig();
        config.setDateFormat(JSON.DEFFAULT_DATE_FORMAT);
        config.setSerializerFeatures(this.fastJsonProperties.getSerializerFeatures());
        ContextValueFilter contextValueFilter = (context, object, name, value) -> {
            if (context == null) {
                if (this.fastJsonProperties.isWriteNullAsStringEmpty()) {
                    return "";
                }
                return value;
            }
            Class fieldClass = context.getFieldClass();
            if (value != null || ClassUtils.isBasicType((Class)fieldClass) || Collection.class.isAssignableFrom(fieldClass)) {
                return value;
            }
            if (this.fastJsonProperties.isWriteNullMapAsEmpty() && Map.class.isAssignableFrom(fieldClass)) {
                return new JSONObject();
            }
            if (this.fastJsonProperties.isWriteNullArrayAsEmpty() && fieldClass.isArray()) {
                return ArrayUtil.newArray((int)0);
            }
            if (this.fastJsonProperties.isWriteNullAsStringEmpty()) {
                return "";
            }
            return value;
        };
        if (this.fastJsonProperties.isWriteNullAsStringEmpty() || this.fastJsonProperties.isWriteNullMapAsEmpty()) {
            config.setSerializeFilters(new SerializeFilter[]{contextValueFilter});
        }
        if ((fieldNamingStrategy = this.fastJsonProperties.getFieldNamingStrategy()) != null) {
            config.getSerializeConfig().setPropertyNamingStrategy(fieldNamingStrategy.getPropertyNamingStrategy());
        }
        converter.setFastJsonConfig(config);
        converters.add(0, (HttpMessageConverter<?>)converter);
        log.info("\u3010\u521d\u59cb\u5316\u914d\u7f6e-FastJsonHttpMessageConverter\u3011\u9ed8\u8ba4\u914d\u7f6e\u4e3afalse\uff0c\u5f53\u524d\u73af\u5883\u4e3atrue\uff1a\u4f7f\u7528FastJson\u4f18\u5148\u4e8e\u9ed8\u8ba4\u7684Jackson\u505ajson\u89e3\u6790 ... \u5df2\u521d\u59cb\u5316\u5b8c\u6bd5\u3002");
    }

    private void mappingJackson2HttpMessageConverterConfig(MappingJackson2HttpMessageConverter converter) {
        ObjectMapper objectMapper = converter.getObjectMapper();
        JsonSerializer<Object> jsonSerializer = new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                JsonStreamContext outputContext = gen.getOutputContext();
                Object currentValue = outputContext.getCurrentValue();
                if (currentValue == null) {
                    this.writeNullOrEmpty(gen);
                    return;
                }
                String currentName = outputContext.getCurrentName();
                Field field = null;
                try {
                    field = ReflectUtil.getField(currentValue.getClass(), (String)currentName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (field == null) {
                    this.writeNullOrEmpty(gen);
                    return;
                }
                Class<?> fieldClass = field.getType();
                if (WebMvcConfig.this.jacksonProperties.isWriteNullStringAsEmpty() && CharSequence.class.isAssignableFrom(fieldClass)) {
                    gen.writeString("");
                    return;
                }
                if (WebMvcConfig.this.jacksonProperties.isWriteNullNumberAsZero() && Number.class.isAssignableFrom(fieldClass)) {
                    gen.writeNumber(0);
                    return;
                }
                if (WebMvcConfig.this.jacksonProperties.isWriteNullBooleanAsFalse() && Boolean.class.isAssignableFrom(fieldClass)) {
                    gen.writeBoolean(false);
                    return;
                }
                if (WebMvcConfig.this.jacksonProperties.isWriteNullMapAsEmpty() && Map.class.isAssignableFrom(fieldClass)) {
                    gen.writeStartObject();
                    gen.writeEndObject();
                    return;
                }
                if (WebMvcConfig.this.jacksonProperties.isWriteNullArrayAsEmpty() && (fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass))) {
                    gen.writeStartArray();
                    gen.writeEndArray();
                    return;
                }
                if (ClassUtils.isBasicType(fieldClass)) {
                    gen.writeNull();
                    return;
                }
                this.writeNullOrEmpty(gen);
            }

            private void writeNullOrEmpty(JsonGenerator gen) throws IOException {
                if (WebMvcConfig.this.jacksonProperties.isWriteNullAsStringEmpty()) {
                    gen.writeString("");
                    return;
                }
                gen.writeNull();
            }
        };
        objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)jsonSerializer);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new JavaBeanArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ArrayArgumentResolver(true));
        resolvers.add((HandlerMethodArgumentResolver)new CustomRequestParamMethodArgumentResolver(true));
    }
}

