/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util;

import ai.yue.library.base.util.StringUtils;
import ai.yue.library.web.ipo.CaptchaIPO;
import ai.yue.library.web.util.servlet.ServletUtils;
import ai.yue.library.web.vo.CaptchaVO;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.servlet.http.HttpSession;

public class CaptchaUtils {
    public static final String CAPTCHA_KEY = "captcha";
    public static final String CAPTCHA_REDIS_PREFIX = "captcha_%s";
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    static Color getRandomColor() {
        Random ran = new Random();
        Color color = new Color(ran.nextInt(256), ran.nextInt(256), ran.nextInt(256));
        return color;
    }

    public static CaptchaVO createCaptchaImage(CaptchaIPO captchaIPO) {
        int i;
        int width = captchaIPO.getWidth();
        int height = captchaIPO.getHeight();
        int charQuantity = captchaIPO.getCharQuantity();
        int fontSize = captchaIPO.getFontSize();
        int interferingLineQuantity = captchaIPO.getInterferingLineQuantity();
        StringBuffer captcha = new StringBuffer();
        BufferedImage captchaImage = new BufferedImage(width, height, 1);
        Graphics graphic = captchaImage.getGraphics();
        graphic.setColor(Color.LIGHT_GRAY);
        graphic.fillRect(0, 0, width, height);
        Random ran = new Random();
        for (i = 0; i < charQuantity; ++i) {
            int n = ran.nextInt(CHARS.length);
            graphic.setColor(CaptchaUtils.getRandomColor());
            graphic.setFont(new Font(null, 3, fontSize));
            graphic.drawString("" + CHARS[n], i * width / charQuantity, height * 2 / 3);
            captcha.append(CHARS[n]);
        }
        for (i = 0; i < interferingLineQuantity; ++i) {
            graphic.setColor(CaptchaUtils.getRandomColor());
            graphic.drawLine(ran.nextInt(width), ran.nextInt(height), ran.nextInt(width), ran.nextInt(height));
        }
        graphic.dispose();
        return CaptchaVO.builder().captcha(captcha.toString()).captchaImage(captchaImage).build();
    }

    public static boolean isValidateCaptcha(String captcha) {
        HttpSession httpSession = ServletUtils.getSession();
        String randCaptcha = (String)httpSession.getAttribute(CAPTCHA_KEY);
        if (StringUtils.isEmpty((CharSequence)randCaptcha) || !randCaptcha.equalsIgnoreCase(captcha)) {
            return false;
        }
        httpSession.removeAttribute(CAPTCHA_KEY);
        return true;
    }
}

