/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.thread.pool;

import ai.yue.library.base.config.thread.pool.AsyncProperties;
import cn.hutool.core.convert.Convert;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractContextDecorator
implements TaskDecorator {
    protected AsyncProperties asyncProperties;

    protected void enableServletAsyncContext(ServletRequestAttributes context, AsyncProperties asyncProperties) {
        if (!asyncProperties.isEnableServletAsyncContext()) {
            return;
        }
        HttpServletRequest request = context.getRequest();
        request.startAsync();
        Object servletAsyncContextTimeoutMillis = request.getAttribute("servletAsyncContextTimeoutMillis");
        if (servletAsyncContextTimeoutMillis == null) {
            servletAsyncContextTimeoutMillis = asyncProperties.getServletAsyncContextTimeoutMillis();
        }
        request.getAsyncContext().setTimeout(Convert.toLong((Object)servletAsyncContextTimeoutMillis).longValue());
    }

    protected void completeServletAsyncContext(ServletRequestAttributes context, AsyncProperties asyncProperties) {
        if (asyncProperties.isEnableServletAsyncContext()) {
            context.getRequest().getAsyncContext().complete();
        }
    }

    public AbstractContextDecorator(AsyncProperties asyncProperties) {
        this.asyncProperties = asyncProperties;
    }
}

