/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util;

import ai.yue.library.base.convert.Convert;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.net.multipart.MultipartFormData;
import cn.hutool.core.net.multipart.UploadSetting;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String HTTP_TCP_NAME = "http://";
    public static final String HTTPS_TCP_NAME = "https://";
    public static final String BEARER_TYPE = "Bearer ";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String POINTCUT = "@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)";

    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static String getAuthToken() {
        return ServletUtils.getAuthToken(ServletUtils.getRequest());
    }

    public static String getAuthToken(HttpServletRequest request) {
        String authToken = StrUtil.subAfter((CharSequence)request.getHeader("Authorization"), (CharSequence)BEARER_TYPE, (boolean)false);
        if (StrUtil.isBlank((CharSequence)authToken)) {
            authToken = request.getParameter(ACCESS_TOKEN);
        }
        return authToken;
    }

    public static JSONObject getParamToJson() {
        return ServletUtils.getParamToJson(ServletUtils.getRequest());
    }

    public static JSONObject getParamToJson(HttpServletRequest request) {
        String body;
        Map<String, String> paramMap = ServletUtils.getParamMap((ServletRequest)request);
        JSONObject paramJson = new JSONObject();
        paramJson.putAll(paramMap);
        boolean getMethod = ServletUtils.isGetMethod(request);
        if (!getMethod && StrUtil.isNotEmpty((CharSequence)(body = ServletUtils.getBody((ServletRequest)request)))) {
            JSONObject jsonBody = Convert.toJSONObject((Object)body);
            paramJson.putAll((Map)jsonBody);
        }
        return paramJson;
    }

    public static <T> T getParamToJavaBean(Class<T> clazz) {
        return ServletUtils.getParamToJavaBean(ServletUtils.getRequest(), clazz);
    }

    public static <T> T getParamToJavaBean(HttpServletRequest request, Class<T> clazz) {
        return (T)Convert.toJavaBean((Object)ServletUtils.getParamToJson(request), clazz);
    }

    public static String getServerURL() {
        HttpServletRequest request = ServletUtils.getRequest();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        return HTTP_TCP_NAME + serverName + ":" + serverPort + contextPath;
    }

    public static void printRequest() {
        HttpServletRequest request = ServletUtils.getRequest();
        Console.error((Object)"========\u5f00\u59cb-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u4fe1\u606f\uff1a");
        Console.log((String)"RemoteAddr\uff1a{}", (Object[])new Object[]{request.getRemoteAddr()});
        Console.log((String)"Method\uff1a{}", (Object[])new Object[]{request.getMethod()});
        Console.log((String)"AuthType\uff1a{}", (Object[])new Object[]{request.getAuthType()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u670d\u52a1\u5668\u4fe1\u606f\uff1a");
        Console.log((String)"ServerURL\uff1a{}", (Object[])new Object[]{ServletUtils.getServerURL()});
        Console.log((String)"RequestURL\uff1a{}", (Object[])new Object[]{request.getRequestURL()});
        Console.log((String)"RequestedSessionId\uff1a{}", (Object[])new Object[]{request.getRequestedSessionId()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a");
        Console.log((String)"QueryString\uff1a{}", (Object[])new Object[]{request.getQueryString()});
        Console.log((String)"ParameterMap\uff1a{}", (Object[])new Object[]{JSONObject.toJSONString((Object)request.getParameterMap())});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u5934\uff1a");
        Console.log((Object)"Headers\uff1a");
        request.getHeaderNames().asIterator().forEachRemaining(headerName -> {
            StringBuilder headerValues = new StringBuilder();
            request.getHeaders(headerName).asIterator().forEachRemaining(headerValue -> headerValues.append((String)headerValue));
            Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{headerName, headerValues});
        });
        Console.log();
        Console.log((Object)"Cookies\uff1a");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{cookie.getName(), cookie.getValue()});
            }
        }
        Console.error((Object)"========\u7ed3\u675f-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
    }

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtils.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getBody(ServletRequest request) {
        String string;
        block8: {
            BufferedReader reader = request.getReader();
            try {
                string = IoUtil.read((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            reader.close();
        }
        return string;
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst((CharSequence)bean.getClass().getSimpleName());
        return (T)BeanUtil.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                Object[] values = request.getParameterValues(key);
                if (ArrayUtil.isEmpty((Object[])values) && ArrayUtil.isEmpty((Object[])(values = request.getParameterValues(beanName + "." + key)))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, (CopyOptions)copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletUtils.fillBean(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return (T)ServletUtils.fillBean(request, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(String ... otherHeaderNames) {
        return ServletUtils.getClientIP(ServletUtils.getRequest(), otherHeaderNames);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return ServletUtils.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }

    public static MultipartFormData getMultipart(ServletRequest request) throws IORuntimeException {
        return ServletUtils.getMultipart(request, new UploadSetting());
    }

    public static MultipartFormData getMultipart(ServletRequest request, UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream((InputStream)request.getInputStream(), CharsetUtil.charset((String)request.getCharacterEncoding()));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return formData;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String name, String charsetName) {
        return ServletUtils.getHeader(request, name, CharsetUtil.charset((String)charsetName));
    }

    public static String getHeader(HttpServletRequest request, String name, Charset charset) {
        String header = request.getHeader(name);
        if (null != header) {
            return CharsetUtil.convert((String)header, (Charset)CharsetUtil.CHARSET_ISO_8859_1, (Charset)charset);
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletUtils.getHeaderIgnoreCase(request, "User-Agent");
        if (StrUtil.isNotBlank((CharSequence)userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return METHOD_GET.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return METHOD_POST.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletUtils.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        return ServletUtils.readCookieMap(httpServletRequest).get(name);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        Object[] cookies = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return MapUtil.empty();
        }
        return IterUtil.toMap((Iterator)new ArrayIter((Object)httpServletRequest.getCookies()), (Map)new CaseInsensitiveMap(), Cookie::getName);
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletUtils.addCookie(response, cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletUtils.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = (String)ObjectUtil.defaultIfNull((Object)FileUtil.getMimeType((String)fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            ServletUtils.write(response, in, contentType, fileName);
        }
        finally {
            IoUtil.close((Closeable)in);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = (String)ObjectUtil.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)fileName, (String)charset)}));
        response.setContentType(contentType);
        ServletUtils.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletUtils.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletUtils.write(response, in, 8192);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtil.copy((InputStream)in, (OutputStream)out, (int)bufferSize);
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)out);
            IoUtil.close((Closeable)in);
        }
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equalsIgnoreCase(value.getClass().getSimpleName())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }
}

