/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.exception;

import ai.yue.library.base.util.I18nUtils;
import ai.yue.library.base.view.Result;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResultResponseBodyHandler
implements ResponseBodyAdvice<Result> {
    private static final Logger log = LoggerFactory.getLogger(ResultResponseBodyHandler.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.getMethod().getReturnType() == Result.class;
    }

    public Result beforeBodyWrite(@Nullable Result body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        Integer code = body.getCode();
        if (code != null) {
            HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
            int status = servletResponse.getStatus();
            if (code != status) {
                servletResponse.setStatus(code.intValue());
            }
        }
        body.setMsg(I18nUtils.getYue((String)body.getMsg()));
        body.setTraceId(MDC.get((String)"traceId"));
        return body;
    }
}

