/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.exception;

import ai.yue.library.base.config.exception.AbstractExceptionHandler;
import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.R;
import ai.yue.library.base.view.Result;
import ai.yue.library.web.util.servlet.ServletUtils;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@ConditionalOnProperty(prefix="yue.exception-handler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ResultExceptionHandler
extends AbstractExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result result = e.getResult();
        ServletUtils.getResponse().setStatus(result.getCode().intValue());
        log.error(result.toString());
        ExceptionUtils.printException((Throwable)e);
        return result;
    }

    @ResponseBody
    @ResponseStatus(code=HttpStatus.METHOD_NOT_ALLOWED)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedExceptionHandler(HttpRequestMethodNotSupportedException e) {
        String uri = ServletUtils.getRequest().getRequestURI();
        Console.error((String)"uri={}", (Object[])new Object[]{uri});
        ExceptionUtils.printException((Throwable)e);
        return R.methodNotAllowed((Object)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public Result<?> paramVoidExceptionHandler() {
        ServletUtils.getResponse().setStatus(432);
        return R.paramVoid();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public Result<?> paramExceptionHandler(ParamException e) {
        ServletUtils.getResponse().setStatus(433);
        ExceptionUtils.printException((Throwable)e);
        return R.paramCheckNotPass((Object)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        ServletUtils.getResponse().setStatus(433);
        String uri = ServletUtils.getRequest().getRequestURI();
        Console.error((String)"uri={}", (Object[])new Object[]{uri});
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        return R.paramCheckNotPass((Object)paramHint);
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Result<?> validateExceptionHandler(ValidateException e) {
        ServletUtils.getResponse().setStatus(433);
        ExceptionUtils.printException((Throwable)e);
        try {
            return R.paramCheckNotPass((Object)Convert.toJSONArray((Object)e.getMessage()));
        }
        catch (Exception exception) {
            return R.paramCheckNotPass((Object)e.getMessage());
        }
    }

    @ResponseBody
    @ExceptionHandler(value={ParamDecryptException.class})
    public Result<?> paramDecryptExceptionHandler(ParamDecryptException e) {
        ServletUtils.getResponse().setStatus(435);
        log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Throwable)e);
        return R.paramDecryptError();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public void authorizeExceptionHandler(AuthorizeException e) throws IOException {
        ExceptionUtils.printException((Throwable)e);
        ServletUtils.getResponse().sendRedirect("");
    }
}

