/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.config.thread.pool;

import ai.yue.library.base.config.thread.pool.AsyncProperties;
import cn.hutool.core.convert.Convert;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ContextDecorator
implements TaskDecorator {
    protected AsyncProperties asyncProperties;

    public Runnable decorate(Runnable runnable) {
        ServletRequestAttributes context = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Map previous = MDC.getCopyOfContextMap();
        ContextDecorator.enableServletAsyncContext(context, this.asyncProperties);
        return () -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                MDC.setContextMap((Map)previous);
                runnable.run();
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
                MDC.clear();
            }
        };
    }

    public static void enableServletAsyncContext(ServletRequestAttributes context, AsyncProperties asyncProperties) {
        if (!asyncProperties.isEnableServletAsyncContext()) {
            return;
        }
        HttpServletRequest request = context.getRequest();
        request.startAsync();
        Object servletAsyncContextTimeoutMillis = request.getAttribute("servletAsyncContextTimeoutMillis");
        if (servletAsyncContextTimeoutMillis == null) {
            servletAsyncContextTimeoutMillis = asyncProperties.getServletAsyncContextTimeoutMillis();
        }
        request.getAsyncContext().setTimeout(Convert.toLong((Object)servletAsyncContextTimeoutMillis).longValue());
    }

    public ContextDecorator(AsyncProperties asyncProperties) {
        this.asyncProperties = asyncProperties;
    }
}

