/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util;

import ai.yue.library.base.convert.Convert;
import ai.yue.library.base.util.StringUtils;
import ai.yue.library.web.util.servlet.ServletUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParamUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestParamUtils.class);

    private RequestParamUtils() {
    }

    public static JSONObject getParam() {
        HttpServletRequest request = ServletUtils.getRequest();
        String contentType = request.getHeader("Content-Type");
        if (StringUtils.isNotEmpty((CharSequence)contentType) && "multipart/form-data".equals(contentType.split(";")[0])) {
            return RequestParamUtils.getRequestUrlParamJson(request);
        }
        return RequestParamUtils.getRawJson(request);
    }

    public static <T> T getParam(Class<T> clazz) {
        JSONObject paramJson = RequestParamUtils.getParam();
        return (T)Convert.toJavaBean((Object)paramJson, clazz);
    }

    private static JSONObject getRequestUrlParamJson(HttpServletRequest request) {
        JSONObject json = new JSONObject();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            json.put(paramName, (Object)request.getParameter(paramName));
        }
        return json;
    }

    private static JSONObject getRawJson(HttpServletRequest request) {
        JSONObject json = RequestParamUtils.getRequestUrlParamJson(request);
        String body = null;
        try {
            body = ServletUtils.getBody((ServletRequest)request);
        }
        catch (IllegalStateException e) {
            log.warn("\u83b7\u53d6body\u8bfb\u53d6\u6d41\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            JSONObject tempJson = Convert.toJSONObject((Object)body);
            json.putAll((Map)tempJson);
        }
        return json;
    }
}

