/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util.servlet.multipart;

import ai.yue.library.web.util.servlet.multipart.MultipartRequestInputStream;
import ai.yue.library.web.util.servlet.multipart.UploadFile;
import ai.yue.library.web.util.servlet.multipart.UploadFileHeader;
import cn.hutool.core.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;

public class MultipartFormData {
    private Map<String, String[]> requestParameters = new HashMap<String, String[]>();
    private Map<String, UploadFile[]> requestFiles = new HashMap<String, UploadFile[]>();
    private boolean loaded;

    public void parseRequest(ServletRequest request) throws IOException {
        this.parseRequestStream((InputStream)request.getInputStream(), request.getCharacterEncoding());
    }

    public void parseRequestStream(InputStream inputStream, String charset) throws IOException {
        UploadFileHeader header;
        this.setLoaded();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream);
        input.readBoundary();
        while ((header = input.readDataHeader(charset)) != null) {
            if (header.isFile) {
                String fileName = header.fileName;
                if (fileName.length() > 0 && header.contentType.contains("application/x-macbinary")) {
                    input.skipBytes(128);
                }
                UploadFile newFile = new UploadFile(header);
                newFile.processStream(input);
                this.putFile(header.formFieldName, newFile);
            } else {
                ByteArrayOutputStream fbos = new ByteArrayOutputStream(1024);
                input.copy(fbos);
                String value = charset != null ? new String(fbos.toByteArray(), charset) : new String(fbos.toByteArray());
                this.putParameter(header.formFieldName, value);
            }
            input.skipBytes(1);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
    }

    public String getParam(String paramName) {
        if (this.requestParameters == null) {
            return null;
        }
        Object[] values = this.requestParameters.get(paramName);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    public Set<String> getParamNames() {
        if (this.requestParameters == null) {
            return Collections.emptySet();
        }
        return this.requestParameters.keySet();
    }

    public String[] getArrayParam(String paramName) {
        if (this.requestParameters == null) {
            return null;
        }
        return this.requestParameters.get(paramName);
    }

    public Map<String, String[]> getParamMap() {
        return this.requestParameters;
    }

    public UploadFile getFile(String paramName) {
        UploadFile[] values = this.getFiles(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public UploadFile[] getFiles(String paramName) {
        if (this.requestFiles == null) {
            return null;
        }
        return this.requestFiles.get(paramName);
    }

    public Set<String> getFileParamNames() {
        if (this.requestFiles == null) {
            return Collections.emptySet();
        }
        return this.requestFiles.keySet();
    }

    public Map<String, UploadFile[]> getFileMap() {
        return this.requestFiles;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void putFile(String name, UploadFile uploadFile) {
        UploadFile[] uploadFileArray;
        Object[] fileUploads = this.requestFiles.get(name);
        if (fileUploads == null) {
            UploadFile[] uploadFileArray2 = new UploadFile[1];
            uploadFileArray = uploadFileArray2;
            uploadFileArray2[0] = uploadFile;
        } else {
            uploadFileArray = (UploadFile[])ArrayUtil.append((Object[])fileUploads, (Object[])new UploadFile[]{uploadFile});
        }
        fileUploads = uploadFileArray;
        this.requestFiles.put(name, (UploadFile[])fileUploads);
    }

    private void putParameter(String name, String value) {
        String[] stringArray;
        Object[] params = this.requestParameters.get(name);
        if (params == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = (String[])ArrayUtil.append((Object[])params, (Object[])new String[]{value});
        }
        params = stringArray;
        this.requestParameters.put(name, (String[])params);
    }

    private void setLoaded() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

